part of user_set;

class UserSetPage extends StatefulWidget {
  const UserSetPage({Key? key}) : super(key: key);

  @override
  State<UserSetPage> createState() => _UserSetPageState();
}

class _UserSetPageState extends State<UserSetPage> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        centerTitle: true,
        title: const Text('设置'),
      ),
      body: Column(
        children: [
          Container(
            margin: const EdgeInsets.symmetric(vertical: 10,horizontal: 10),
            padding: const EdgeInsets.only(right: 10),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(8),
              color: Colors.white,
              boxShadow: [
                BoxShadow(
                  color: const Color(0xFFC7C7C7).withOpacity(0.5),
                  offset: const Offset(3, 0),
                  blurRadius: 10.w,
                  spreadRadius: 0.w,
                ),
              ],
            ),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                GestureDetector(
                  onTap: () async{
                    clearCache();
                  },
                  child: Container(
                    color: Colors.white,
                    margin: const EdgeInsets.only(left: 15),
                    height:45,
                    alignment: Alignment.centerLeft,
                    child: const Text('清除缓存',style: TextStyle(fontSize: 14,color: Colours.c3)),
                  ),
                ),
                Container(
                  margin: const EdgeInsets.only(left: 10),
                  height: 0.5,
                  color:Colours.cF0,
                ),
                GestureDetector(
                  onTap: () async{
                    UpdateModel model = await MineAPI.update();
                    // 有新版本
                    if (model.version !=null){

                    }
                  },
                  child: Container(
                    color: Colors.white,
                    margin: const EdgeInsets.only(left: 15),
                    height:45,
                    alignment: Alignment.centerLeft,
                    child: const Text('查看更新 >',style: TextStyle(fontSize: 14,color: Colours.c3)),
                  ),
                ),
                Container(
                  margin: const EdgeInsets.symmetric(horizontal: 10),
                  height: 0.5,
                  color:Colours.cF0,
                ),
                GestureDetector(
                  onTap: (){
                    context.pushNamed(Routes.version);
                  },
                  child: Container(
                    color: Colors.white,
                    margin: const EdgeInsets.only(left: 15),
                    height:45,
                    alignment: Alignment.centerLeft,
                    child: const Text('版本介绍 >',style: TextStyle(fontSize: 14,color: Colours.c3)),
                  ),
                )
              ],
            ),
          ),
          GestureDetector(
            onTap: () async{
              final result = await AccountAPI.logout();
              if (result){
                Toast.show('退出成功');
                await UserStore.to.logout();
                if(context.mounted){
                  context.goNamed(Routes.main);
                }
              }
            },
            child: Container(
              height: 42,
              width: double.infinity,
              alignment: Alignment.center,
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(8),
                color: Colors.white,
                boxShadow: [
                  BoxShadow(
                    color: const Color(0xFFC7C7C7).withOpacity(0.5),
                    offset: const Offset(3, 0),
                    blurRadius: 10.w,
                    spreadRadius: 0.w,
                  ),
                ],
              ),
              margin: const EdgeInsets.symmetric(horizontal: AppTheme.margin),
              child: const Text('退出登录',style: TextStyle(fontSize: 14,color: Colours.c3),),
            ),
          )
        ],
      ),
    );
  }

  void clearCache() {
    ClearCache().clearApplicationCache();
    Toast.show('清除完成');
  }
}
