part of user_order_completed;

/// 已完成订单
class UserOrderCompletedController extends GetxController {
  final String orderNum; // 订单编号
  UserOrderCompletedController(this.orderNum);

  /*{
    getOrderInfo();
  }*/

  late OrderInfoModel model = OrderInfoModel();

  // 应付款、订单编号等
  List<OrderCompletedModel> orderCompleteds = [];

  // @override
  // void onInit() {
  //   // getOrderInfo();
  //   super.onInit();
  // }

  @override
  void onReady() {
    getOrderInfo();
    super.onReady();
  }

  /// 获取订单信息
  void getOrderInfo() async {
    model = await MineAPI.getOrderInfo(orderNum: orderNum);
    String payWay = '';
    if (model.payType == 1) {
      payWay = '微信';
    } else if (model.payType == 2) {
      payWay = '支付宝';
    } else if (model.payType == 3) {
      payWay = '紫荆币';
    }
    orderCompleteds = [
      OrderCompletedModel(
          name: '应付款',
          value: model.finalTotalPrice.toString(),
          other: (double.parse(model.totalPrice.toString()) -
                  double.parse(model.finalTotalPrice.toString()))
              .toString()),
      OrderCompletedModel(name: '订单编号', value: model.ordersnum.toString()),
      OrderCompletedModel(name: '支付方式', value: payWay),
      OrderCompletedModel(name: '支付时间', value: model.payTime.toString()),
      OrderCompletedModel(name: '下单时间', value: model.createTime.toString()),
    ];

    update();
  }

  /// 判断图书是否已评价，全部评价返回0，全部未评价返回1，部分未评价返回2
  int judgeComments() {
    // 无图书
    if (model.bookList == null || model.bookList!.isEmpty) {
      return 1;
    } else {
      List<BookListModel>? bookList = model.bookList;
      int i = 0;
      for (BookListModel book in bookList!) {
        if (book.rating == 0) {
          i++;
        }
      }
      // 全部已评价
      if (i == 0) {
        return 0;
      }
      // 全部未评价
      if (model.bookList!.length == i) {
        return 1;
      } else { // 部分未评价
        return 2;
      }
    }
  }
}
