part of book_shop;

class BookshopController extends GetxController {

  final EasyRefreshController refreshController = EasyRefreshController(
    controlFinishLoad: true,
    controlFinishRefresh: true,
  );

  // 书架数组
  List<CourseModel> carts = [];
  // 是否全选
  late bool all = false;

  final int _limit = 10;
  int _page = 1;
  bool _noMore = false;




  @override
  void onReady() {
    onRefresh();
    super.onReady();
  }

  @override
  void onClose() {
    refreshController.dispose();
    super.onClose();
  }

  // 选中 与 取消选中
  void select(CourseModel courseModel){
    if (courseModel.status == 1){
      courseModel.selected = !courseModel.selected;
    }

    bool checkAll = true;
    for (CourseModel model in carts){
      if (model.status == 1){
        if (model.selected == false){
          checkAll = false;
        }
      }
    }
    all = checkAll;

    update();
  }

  // 获取选中数量
  int get num {
    int num = 0;
    for (CourseModel model in carts){
      if (model.selected == true){
        num ++;
      }
    }
    return num;
  }

  // 获取总价
  //总价格
  double get allPrice{
    Decimal price = Decimal.zero;
    for (CourseModel model in carts) {
      if (model.status == 1){
        if (model.selected == true){
          price = price + Decimal.parse(model.vipPrice??'0.00');
        }
      }
    }
    return price.toDouble();
  }

  /*  另一种方式处理精度
  * double get allPrice {
  double price = 0;

  for (CourseModel model in carts) {
    if (model.status == 1 && model.selected == true) {
      print('----------------11111----------------${model.vipPrice ?? '0.00'}');
      price += double.parse(model.vipPrice ?? '0.00');
    }
  }

  NumberFormat formatter = NumberFormat("0.00");
  String formattedPrice = formatter.format(price);
  print('-------------22222-------------------$formattedPrice');

  return double.parse(formattedPrice);
}
  * */


  // 全选
  void selectAll() {
    if(all == false){
      for (CourseModel model in carts) {
        if (model.status == 1){
          model.selected = true;
        }
      }
      all = true;
    }
    else {
      for (CourseModel model in carts) {
        if (model.status == 1){
          model.selected = false;
        }
      }
      all = false;
    }
    update();

  }

  /// 购买的书籍
  List<CourseModel> get buy {
    List<CourseModel> temp = [];
    for (CourseModel model in carts) {
      if (model.status == 1){
         if (model.selected == true){
           temp.add(model);
         }
      }
    }
    return temp;
  }


  /// 删除购物车 单个书籍
  void delCart({
    required String cartId,
  }) async {
    bool result = await ShopAPI.delCart(
        cartId: cartId);
    if (result) {
      onRefresh();
    }
  }

  /// 获取课程内图书列表
  Future<void> _getCart([bool isRefresh = false]) async {
    if (isRefresh) _page = 1;
    // 网路请求
    final result = await ShopAPI.cart(
        page: _page,
        limit: _limit
    );
    // 如果是刷新 清理数据
    if (isRefresh) carts.clear();
    carts.addAll(_test());
    carts.addAll(result);
    _page ++;
    _noMore = result.length < _limit;
    update();

  }


  void onRefresh() async {
    try {
      await _getCart(true);
      refreshController.finishRefresh(IndicatorResult.success);
      refreshController.resetFooter();
    } catch (error) {
      refreshController.finishRefresh(IndicatorResult.fail);
    }
  }

  void onLoading() async {
    if (_noMore) {
      refreshController.finishLoad(IndicatorResult.noMore);
      return;
    }
    try {
      await _getCart();
      refreshController.finishLoad();
    } catch (error) {
      refreshController.finishLoad(IndicatorResult.fail);
    }
  }

  List<CourseModel> _test(){
    return [
      CourseModel(bookName: '哈1',bookId: 111,vipPrice: '12.33',authors: 'John',status: 1),
      CourseModel(bookName: '哈2',bookId: 123,vipPrice: '12.00',authors: 'json',status: 1),
      CourseModel(bookName: '哈3',bookId: 11,vipPrice: '12.43',authors: 'hash',status: 1),
    ];
  }

}