part of user_coin;

class UserCoinPage extends StatefulWidget {
  const UserCoinPage({Key? key}) : super(key: key);

  @override
  State<UserCoinPage> createState() => _UserCoinPageState();
}

class _UserCoinPageState extends State<UserCoinPage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<UserCoinController>(
      init: UserCoinController(),
      builder: (controller) => Scaffold(
        appBar: CustomAppBar(
          title: const Text('紫荆币'),
          actions: [
            GestureDetector(
              onTap: (){
                showModalBottomSheet(
                  context: context,
                  builder: (BuildContext context) {
                    return Container(
                      height: 200,
                      color: Colors.white,
                      child: const Center(
                        child: Text(
                          'This is the bottom sheet content',
                          style: TextStyle(fontSize: 18),
                        ),
                      ),
                    );
                  },
                ).then((value) {
                  print('================================================================');
                });
              },
                child: const Text('充值',style: TextStyle(color: Colours.c3,fontSize: 14,height: 1.5,fontWeight: Fonts.medium),)
            )
          ],
        ),
        body: CustomPullScrollView(
          controller: controller.refreshController,
          onRefresh: controller.onRefresh,
          onLoading: controller.onLoading,
          child: Container(
            margin: const EdgeInsets.all(10),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(8),
              color: Colors.white,
              boxShadow: [
                BoxShadow(
                  color: const Color(0xFFC7C7C7).withOpacity(0.5),
                  offset: const Offset(3, 0),
                  blurRadius: 10.w,
                  spreadRadius: 0.w,
                ),
              ],
            ),
            child: ListView.builder(
              itemBuilder: (BuildContext context, int index){
                return BuildCell(model: controller.coins[index],);
              },
              itemCount: controller.coins.length,
            ),
          ),
        ),
      ),
    );
  }
}
