part of user_order;

class UserOrderPage extends StatefulWidget {
  const UserOrderPage({Key? key /*, required this.userInfo*/
      })
      : super(key: key);

  @override
  State<UserOrderPage> createState() => _UserOrderState();
}

int tab = 0;

class _UserOrderState extends State<UserOrderPage> {
/*  late num? selectedGender ; // 选中的性别
  @override
  void initState() {
    super.initState();
    selectedGender = widget.userInfo.sex;
    // 在这里可以使用 localVariable 进行操作
  }*/

  @override
  Widget build(BuildContext context) {
    return GetBuilder<UserOrderController>(
      init: UserOrderController(tab),
      builder: (controller) => Scaffold(
        appBar: CustomAppBar(
          automaticallyImplyLeading: false,
          titleSpacing: 0,
          title: Padding(
            padding: EdgeInsets.symmetric(horizontal: AppTheme.margin),
            child: CustomInputSearch(
              controller: controller.searchController,
              readOnly: false,
              hintText: '搜索我的订单',
              onTap: () {
                // context.pushNamed(Routes.msgs);
              },
              onEditingComplete: () {
                controller._getOrders(
                    isRefresh: true,
                    keys: controller.searchController.text,
                    tabIndex: controller._tabController.index);
                // FocusScope.of(context).unfocus();
                FocusNode blankNode = FocusNode();
                FocusScope.of(context).requestFocus(blankNode); //指定为空白焦点
              },
            ),
          ),
          actions: [
            GestureDetector(
              onTap: () {
                context.pop();
              },
              child: Container(
                padding: EdgeInsets.only(left: 10.w, top: 10.w, bottom: 10.w),
                child: Text(
                  '取消',
                  style:
                      TextStyle(fontSize: 14.w, height: 1.5, color: Colours.c3),
                ),
              ),
            )
          ],
        ),
        body: _buildBody(controller),
      ),
    );
  }

  Widget _buildBody(UserOrderController controller) {
    return DefaultTabController(
        length: controller.tabs.length,
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            ClipRRect(
              borderRadius: const BorderRadius.only(
                  topLeft: Radius.circular(5), topRight: Radius.circular(5)),
              child: Container(
                width: double.infinity,
                color: Colors.white,
                height: 35.w,
                child: TabBar(
                    indicator: UnderlineTabIndicator(
                      borderRadius: BorderRadius.circular(0.75),
                      borderSide:
                          BorderSide(width: 1.5.w, color: AppTheme.primary),
                      insets: EdgeInsets.symmetric(
                          horizontal:24.w), // 设置标签下面指示器的水平内边距
                    ),
                    labelPadding: EdgeInsets.symmetric(horizontal: 15.w),
                    indicatorSize: TabBarIndicatorSize.label,
                    indicatorColor: AppTheme.primary,
                    indicatorWeight: 1.5,
                    labelStyle: TextStyle(
                        color: AppTheme.primary,
                        fontSize: 15.w,
                        height: 1.5,
                        fontWeight: Fonts.medium),
                    unselectedLabelColor: Colours.c9,
                    unselectedLabelStyle: TextStyle(
                        color: Colours.c9, fontSize: 15.w, height: 1.5),
                    isScrollable: true,
                    controller: controller._tabController,
                    tabs: controller.tabs),
              ),
            ),
            Expanded(
              child: TabBarView(
                  controller: controller._tabController,
                  children: List.generate(controller.tabs.length, (index) {
                    tab = index;
                    return BuildListPage(
                      tag:
                          tab, models:controller.orderList,controller: controller,/*,context: context,*/
                    );
                  })),
            )
          ],
        ));
  }
}
