part of user_order;

/// 已完成item
class BuiltCompleted extends StatelessWidget {
  final OrderListModel model;

  // final BuildContext context;

  const BuiltCompleted({Key? key, required this.model /*,required this.context*/
      })
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: () { context.pushNamed(Routes.orderCompleted);},
      child:  Container(
          margin: EdgeInsets.only(left: 10.w, right: 10.w, top: 10.w),
          padding: EdgeInsets.only(left: 11.5.w, bottom: 12.w),
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(8.w),
            color: Colors.white,
            boxShadow: [
              BoxShadow(
                color: const Color(0xFFC7C7C7).withOpacity(0.5),
                offset: Offset(1.5.w, 0),
                blurRadius: 7.w,
                spreadRadius: 0.w,
              ),
            ],
          ),
          child: _buildCom(context)),
    );

  }

  Widget _buildCom(BuildContext context) {
    if (model.cartList!.length == 1) {
      return _buildOne(context);
    } else if (model.cartList!.length > 1) {
      return _buildList(context);
    }
    return _buildOne(context);
  }

  Widget _buildOne(BuildContext context) {
    return Row(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Column(
          mainAxisAlignment: MainAxisAlignment.start,
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Container(
              margin: EdgeInsets.only(top: 7.5.w),
              child: Text(
                model.createTime.toString().split(" ")[0],
                style: TextStyle(
                  fontSize: 12.w,
                  color: Colours.c9,
                ),
              ),
            ),
            Container(
              margin: EdgeInsets.only(
                top: 8.w,
              ),
              padding: EdgeInsets.all(2.w),
              height: 88.w,
              width: 73,
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(4.w),
                color: Colors.white,
                boxShadow: [
                  BoxShadow(
                    color: const Color(0xFF707070).withOpacity(0.5),
                    offset: const Offset(0, 0),
                    blurRadius: 4.5.w,
                    spreadRadius: 0.w,
                  ),
                ],
              ),
              child: Image.network(
                model.cartList![0].img??'',
                // 用实际图片链接替换
                fit: BoxFit.cover,
              ),
            ),
          ],
        ),
        Expanded(
          child: Column(
            mainAxisAlignment: MainAxisAlignment.start,
            children: [
              // 右上角等待付款
              Align(
                alignment: Alignment.topRight,
                child: Container(
                    margin: EdgeInsets.only(top: 6.5.w, right: 15.w),
                    child: Text(
                      '已完成',
                      style: TextStyle(fontSize: 13.w, color: Colours.c9),
                    )),
              ),
              Align(
                  alignment: Alignment.centerLeft,
                  child: Container(
                    padding: EdgeInsets.only(
                        left: 12.0.w, top: 12.5.w, right: 49.5.w),
                    child: RichText(
                      text: TextSpan(
                        children: [
                          TextSpan(
                            text: model.cartList![0].introduction ?? '',
                            style: TextStyle(
                              color: Colours.c3,
                              fontWeight: Fonts.medium,
                              fontSize: 13.w,
                            ),
                          ),
                          TextSpan(
                            text: '\n\n',
                            style: TextStyle(
                              color: Colours.c3,
                              fontWeight: Fonts.medium,
                              fontSize: 13.w,
                            ),
                          ),
                        ],
                      ),
                      maxLines: 2,
                      overflow: TextOverflow.ellipsis,

                    ),
                  )),
              SizedBox(height: 22.5.w),
              Container(
                margin: EdgeInsets.only(left: 12.w, right: 15.w),
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    Text(
                      "¥${model.finalTotalPrice}",
                      style: TextStyle(
                        color: Colours.cAB1941,
                        fontWeight: Fonts.medium,
                        fontSize: 14.w,
                      ),
                    ),
                    Align(
                      alignment: Alignment.centerRight,
                      child: Container(
                        padding: EdgeInsets.symmetric(horizontal: 12.w),
                        height: 23.w,
                        decoration: BoxDecoration(
                            borderRadius: BorderRadius.circular(10.w),
                            border: Border.all(
                                color: Colours.cC31F4C, width: 0.5.w)),
                        child: Center(
                          child: GestureDetector(
                              onTap: () {
                                // print("保存昵称");
                                context.pushNamed(Routes.orderEvaluate);
                              },
                              child: Text(
                                '去评价',
                                style: TextStyle(
                                    fontSize: 12.w, color: Colours.cC31F4C),
                              )),
                        ),
                      ),
                    ),
                  ],
                ),
              ),
            ],
          ),
        ),
      ],
    );
  }

  Widget _buildList(BuildContext context) {
    return Container(
      padding: EdgeInsets.only(right: 15.w),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        mainAxisAlignment: MainAxisAlignment.start,
        children: [
          Row(
            crossAxisAlignment: CrossAxisAlignment.start,
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Padding(
                padding: EdgeInsets.only(top: 7.5.w, bottom: 8.w),
                child: Text(
                  model.createTime.toString().split(" ")[0],
                  style: TextStyle(
                    fontSize: 12.w,
                    color: Colours.c9,
                  ),
                ),
              ),
              Padding(
                padding: EdgeInsets.only(top: 6.5.w),
                child: Text(
                  '已完成',
                  style: TextStyle(fontSize: 13.w, color: Colours.c9),
                ),
              ),
            ],
          ),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              SizedBox(
                height: 92.w,
                width: 260.5.w,
                child: ListView.builder(
                  itemBuilder: (BuildContext context, int index) {
                    CartListModel cartModel = model.cartList![index];
                    return Container(
                      margin: EdgeInsets.only(
                        right: 8.w,
                      ),
                      padding: EdgeInsets.all(2.w),
                      height: 88.w,
                      width: 73,
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(4.w),
                        color: Colors.white,
                        boxShadow: [
                          BoxShadow(
                            color: const Color(0xFF707070).withOpacity(0.5),
                            offset: const Offset(0, 0),
                            blurRadius: 4.5.w,
                            spreadRadius: 0.w,
                          ),
                        ],
                      ),
                      child: Image.network(
                        cartModel.img??'',
                        // 用实际图片链接替换
                        fit: BoxFit.cover,
                      ),
                    );
                  },
                  scrollDirection: Axis.horizontal,
                  itemCount: model.cartList?.length,
                ),
              ),
              Align(
                alignment: Alignment.centerRight,
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.end,
                  crossAxisAlignment: CrossAxisAlignment.end,
                  children: [
                    SizedBox(
                      height: 25.w,
                    ),
                    Padding(
                      padding: EdgeInsets.only(right: 11.w),
                      child: Text(
                        '¥${model.totalPrice??''}',
                        style: TextStyle(
                          color: Colours.cAB1941,
                          fontWeight: Fonts.medium,
                          fontSize: 14.w,
                        ),
                      ),
                    ),
                    Padding(
                      padding: EdgeInsets.only(right: 11.w, top: 0.5),
                      child: Text(
                        '共${model.cartList!.isEmpty?0:model.cartList?.length}件',
                        style: TextStyle(
                          color: Colours.c9,
                          fontSize: 10.w,
                        ),
                      ),
                    ),
                    SizedBox(
                      height: 13.5.w,
                    ),
                    Container(
                      height: 23.w,
                      width: 60.w,
                      decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(10.w),
                          border:
                              Border.all(color: Colours.cC31F4C, width: 0.5.w)),
                      child: Center(
                        child: GestureDetector(
                            onTap: () {
                              context.pushNamed(Routes.orderEvaluate);
                            },
                            child: Text(
                              '继续评价',
                              style: TextStyle(
                                  fontSize: 10.w, color: Colours.cC31F4C),
                            )),
                      ),
                    ),
                  ],
                ),
              )
            ],
          ),
        ],
      ),
    );
  }
}
