part of course;

class Book extends StatelessWidget {
  final CourseModel model;
  final void Function() onTapContinue;
  const Book({
    Key? key,
    required this.model,
    required this.onTapContinue
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(8.w),
        color: const Color(0xFFF9F9F9),
        boxShadow: [
          BoxShadow(
            color: const Color(0xFFC7C7C7).withOpacity(0.5),
            offset: Offset(3.w, 0),
            blurRadius: 10.w,
            spreadRadius: 0.w,
          ),
        ],
      ),
      margin: EdgeInsets.only(right: 13.w),
      padding: EdgeInsets.only(left: 10.w,right: 10.w,bottom: 13.5.w,top: 16.5.w),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          Expanded(
            child: AspectRatio(
              aspectRatio: 0.85,
              child: CustomCard(
                url: model.img??'',
              )
            ),
          ),
          Gaps.vGaps10,
          SizedBox(
            width: double.infinity,
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Text(model.bookName??'',style: TextStyle(fontSize: 15.w,color: Colours.c3),maxLines: 1,overflow: TextOverflow.ellipsis,),
                SizedBox(height: 6.w,),
                Text(model.authors ??'',style: TextStyle(fontSize:12.w,height: 1.3,color: Colours.c6,),textAlign: TextAlign.left,maxLines: 1,overflow: TextOverflow.ellipsis),
              ],
            ),
          ),
          Gaps.vGaps5,
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Container(
                color: model.type ==0||model.type ==1 ?Colours.cEF :AppTheme.primary.withOpacity(0.1),
                padding: EdgeInsets.symmetric(horizontal: 3.5.w),
                child: Text(model.typeName,style: TextStyle(fontSize: 11.w,height: 1.3,color: model.type ==0||model.type ==1 ?Colours.c9:AppTheme.primary),),
              ),
              model.type == 2? GestureDetector(
                onTap: (){
                  onTapContinue();
                },
                  child: Text('继续学习',style: TextStyle(fontSize: 11.w,height: 1.3,color: AppTheme.primary,fontWeight: Fonts.boldSemi),)
              ):const SizedBox()
            ],
          )
        ],
      ),
    );
  }
}
