part of user_order;

/// 待付款item
class BuiltAwaiting extends StatelessWidget {
  final OrderListModel model;
  final UserOrderController controller;

  const BuiltAwaiting({Key? key, required this.model, required this.controller})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: () async {
        context.pushNamed(Routes.orderAwaiting,
            queryParameters: {'orderNum': model.ordersnum}).then((value){
          controller.onRefresh();
        });
      },
      child: Container(
        margin: EdgeInsets.only(left: 10.w, right: 10.w, top: 10.w),
        padding: EdgeInsets.only(left: 11.5.w, bottom: 12.w),
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(8.w),
          color: Colors.white,
          boxShadow: [
            BoxShadow(
              color: const Color(0xFFC7C7C7).withOpacity(0.5),
              offset: Offset(1.5.w, 0),
              blurRadius: 7.w,
              spreadRadius: 0.w,
            ),
          ],
        ),
        child: _buildCom(context),
      ),
    );
  }

  Widget _buildCom(BuildContext context) {
    if (model.cartList!.length == 1) {
      return _buildOne(context);
    } else if (model.cartList!.length > 1) {
      return _buildList(context);
    }
    return _buildOne(context);
  }

  Widget _buildOne(BuildContext context) {
    return Row(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Container(
          margin: EdgeInsets.only(
            top: 12.w,
          ),
          padding: EdgeInsets.all(2.w),
          height: 88.w,
          width: 73,
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(4.w),
            color: Colors.white,
            boxShadow: [
              BoxShadow(
                color: const Color(0xFF707070).withOpacity(0.5),
                offset: const Offset(0, 0),
                blurRadius: 4.5.w,
                spreadRadius: 0.w,
              ),
            ],
          ),
          child: Image.network(
            model.cartList![0].img ?? '',
            // 用实际图片链接替换
            fit: BoxFit.cover,
          ),
        ),
        Expanded(
          child: Column(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Column(
                mainAxisAlignment: MainAxisAlignment.start,
                children: [
                  Align(
                    alignment: Alignment.topRight,
                    child: Container(
                      margin: EdgeInsets.only(top: 4.5.w, right: 4.w),
                      width: 100,
                      height: 20,
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.center,
                        children: [
                          // 左半部分的文字
                          Container(
                            decoration: BoxDecoration(
                              borderRadius: BorderRadius.only(
                                  topLeft: Radius.circular(180.w),
                                  bottomLeft: Radius.circular(180.w)),
                              color: Colours.cC31F4C,
                            ),
                            height: double.infinity,
                            width: 50,
                            child: Align(
                              alignment: Alignment.center,
                              child: Text(
                                '等待付款',
                                style: TextStyle(
                                  color: Colors.white,
                                  fontSize: 10.w,
                                  fontWeight: Fonts.medium,
                                ),
                              ),
                            ),
                          ),

                          // 右半部分的文字
                          Container(
                            decoration: BoxDecoration(
                              borderRadius: BorderRadius.only(
                                  topRight: Radius.circular(180.w),
                                  bottomRight: Radius.circular(180.w)),
                              color: Colours.cC31F4C2,
                            ),
                            height: double.infinity,
                            width: 50,
                            child: Align(
                              alignment: Alignment.center,
                              child: Text(
                                '${(30 - (DateTime.now().difference(DateTime.parse(model.createTime.toString()))).inMinutes)==0?
                                1:30 - (DateTime.now().difference(DateTime.parse(model.createTime.toString()))).inMinutes}分钟',
                                style: TextStyle(
                                    color: Colours.cC31F4C,
                                    fontSize: 10.w,
                                    fontWeight: Fonts.medium),
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  ),
                  /* Align(
                      alignment: Alignment.centerLeft,
                      child: Container(
                        padding: EdgeInsets.only(left: 12.0.w, top: 8.w, right: 49.5.w),
                        child:Text(
                          model.cartList![0].introduction??'',
                          style: TextStyle(
                            color: Colours.c3,
                            fontWeight: Fonts.medium,
                            fontSize: 13.w,
                          ),
                          maxLines: 2,
                          overflow: TextOverflow.ellipsis, // 超过部分显示省略号
                        ),
                      )),*/
                  Align(
                      alignment: Alignment.centerLeft,
                      child: Container(
                        padding: EdgeInsets.only(
                            left: 12.0.w, top: 12.5.w, right: 49.5.w),
                        child: RichText(
                          text: TextSpan(
                            children: [
                              TextSpan(
                                text: model.cartList![0].name ?? '',
                                style: TextStyle(
                                  color: Colours.c3,
                                  fontWeight: Fonts.medium,
                                  fontSize: 13.w,
                                ),
                              ),
                              TextSpan(
                                text: '\n\n',
                                style: TextStyle(
                                  color: Colours.c3,
                                  fontWeight: Fonts.medium,
                                  fontSize: 13.w,
                                ),
                              ),
                            ],
                          ),
                          maxLines: 2,
                          overflow: TextOverflow.ellipsis,
                        ),
                      )),
                  SizedBox(height: 10.5.w),
                ],
              ),
              Container(
                height: Checkbox.width,
                alignment: Alignment.bottomLeft,
                margin: EdgeInsets.only(left: 12.w),
                child: Text(
                  "¥${model.finalTotalPrice}",
                  style: TextStyle(
                    color: Colours.cAB1941,
                    fontWeight: Fonts.medium,
                    fontSize: 14.w,
                  ),
                ),
              ),
              /* Align(
                alignment: Alignment.bottomLeft,
                child: Container(
                  margin: EdgeInsets.only(left: 12.w),
                  child: Text(
                    "¥${model.finalTotalPrice}",
                    style: TextStyle(
                      color: Colours.cAB1941,
                      fontWeight: Fonts.medium,
                      fontSize: 14.w,
                    ),
                  ),
                ),
              ),*/
            ],
          ),
        ),
      ],
    );
  }

  Widget _buildList(BuildContext context) {
    return Container(
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        mainAxisAlignment: MainAxisAlignment.start,
        children: [
          Align(
            alignment: Alignment.topRight,
            child: Container(
              margin: EdgeInsets.only(top: 4.5.w, right: 4.w),
              width: 100,
              height: 20,
              child: Row(
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  // 左半部分的文字
                  Container(
                    decoration: BoxDecoration(
                      borderRadius: BorderRadius.only(
                          topLeft: Radius.circular(180.w),
                          bottomLeft: Radius.circular(180.w)),
                      color: Colours.cC31F4C,
                    ),
                    height: double.infinity,
                    width: 50,
                    child: Align(
                      alignment: Alignment.center,
                      child: Text(
                        '等待付款',
                        style: TextStyle(
                          color: Colors.white,
                          fontSize: 10.w,
                          fontWeight: Fonts.medium,
                        ),
                      ),
                    ),
                  ),

                  // 右半部分的文字
                  Container(
                    decoration: BoxDecoration(
                      borderRadius: BorderRadius.only(
                          topRight: Radius.circular(180.w),
                          bottomRight: Radius.circular(180.w)),
                      color: Colours.cC31F4C2,
                    ),
                    height: double.infinity,
                    width: 50,
                    child: Align(
                      alignment: Alignment.center,
                      child: Text(
    '${(30 - (DateTime.now().difference(DateTime.parse(model.createTime.toString()))).inMinutes)==0?
    1:30 - (DateTime.now().difference(DateTime.parse(model.createTime.toString()))).inMinutes}分钟',
                        style: TextStyle(
                            color: Colours.cC31F4C,
                            fontSize: 10.w,
                            fontWeight: Fonts.medium),
                      ),
                    ),
                  ),
                ],
              ),
            ),
          ),
          SizedBox(
            height: 2.w,
          ),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              SizedBox(
                height: 92.w,
                width: 260.5.w,
                child: ListView.builder(
                  itemBuilder: (BuildContext context, int index) {
                    CartListModel cartModel = model.cartList![index];
                    return Container(
                      margin: EdgeInsets.only(
                        right: 8.w,
                      ),
                      padding: EdgeInsets.all(2.w),
                      height: 88.w,
                      width: 73,
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(4.w),
                        color: Colors.white,
                        boxShadow: [
                          BoxShadow(
                            color: const Color(0xFF707070).withOpacity(0.5),
                            offset: const Offset(0, 0),
                            blurRadius: 4.5.w,
                            spreadRadius: 0.w,
                          ),
                        ],
                      ),
                      child: Image.network(
                        cartModel.img ?? '',
                        // 用实际图片链接替换
                        fit: BoxFit.cover,
                      ),
                    );
                  },
                  scrollDirection: Axis.horizontal,
                  itemCount: model.cartList?.length,
                ),
              ),
              Align(
                alignment: Alignment.centerRight,
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.end,
                  crossAxisAlignment: CrossAxisAlignment.end,
                  children: [
                    SizedBox(
                      height: 25.w,
                    ),
                    Padding(
                      padding: EdgeInsets.only(right: 26.w),
                      child: Text(
                        '¥${model.totalPrice ?? ''}',
                        style: TextStyle(
                          color: Colours.cAB1941,
                          fontWeight: Fonts.medium,
                          fontSize: 14.w,
                        ),
                      ),
                    ),
                    Padding(
                      padding: EdgeInsets.only(right: 26.w, top: 0.5),
                      child: Text(
                        '共${model.cartList!.isEmpty ? 0 : model.cartList?.length}件',
                        style: TextStyle(
                          color: Colours.c9,
                          fontSize: 10.w,
                        ),
                      ),
                    ),
                    SizedBox(
                      height: 13.5.w,
                    ),
                    Container(
                      height: 23.w,
                      width: 60.w,
                      margin: EdgeInsets.only(right: 15.w),
                      decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(10.w),
                          border:
                              Border.all(color: Colours.cC31F4C, width: 0.5.w)),
                      child: Center(
                        child: GestureDetector(
                            onTap: () {
                              context.pushNamed(Routes.orderEvaluate);
                            },
                            child: Text(
                              '付款',
                              style: TextStyle(
                                  fontSize: 10.w, color: Colours.cC31F4C),
                            )),
                      ),
                    ),
                  ],
                ),
              )
            ],
          ),
        ],
      ),
    );
  }
}
