part of apis;

abstract class MineAPI {
  /// 1、个人信息以及8个数据
  ///
  static Future<UserInfoModel> userInfo() async {
    final result = await HttpService.to.post(
      '/v1/members/Information/getMyStatistics',
      params: {},
    );
    if (result.data is! Map) return UserInfoModel();
    return UserInfoModel.fromJson(result.data);
  }

  /// 2、我的收藏
  static Future<List<CourseModel>> love({
    int page = 1,
    int limit = 10,
  }) async {
    final result = await HttpService.to.post(
      '/v1/members/Information/myCollection',
      params: {
        'page': page,
        'page_size': limit,
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index) {
      return CourseModel.fromJson(result.data['list'][index]);
    });
  }

  /// 3、笔记
  ///
  static Future<List<CourseModel>> note({
    int page = 1,
    int limit = 10,
  }) async {
    final result = await HttpService.to.post(
      '/v1/members/Information/myNotes',
      params: {
        'page': page,
        'page_size': limit,
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index) {
      return CourseModel.fromJson(result.data['list'][index]);
    });
  }

  /// 4、错题
  ///
  static Future<List<CourseModel>> wrong({
    int page = 1,
    int limit = 10,
  }) async {
    final result = await HttpService.to.post(
      '/v1/members/Information/myWrongQuestion',
      params: {
        'page': page,
        'page_size': limit,
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index) {
      return CourseModel.fromJson(result.data['list'][index]);
    });
  }

  /// 5、紫金币记录
  ///
  static Future<List<RecordModel>> coin({
    int page = 1,
    int limit = 10,
  }) async {
    final result = await HttpService.to.post(
      '/v1/members/Information/getBeanList',
      params: {
        'page': page,
        'page_size': limit,
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index) {
      return RecordModel.fromJson(result.data['list'][index]);
    });
  }

  /// 6、积分记录
  ///
  static Future<List<RecordModel>> point({
    int page = 1,
    int limit = 10,
  }) async {
    final result = await HttpService.to.post(
      '/v1/members/Information/getIntegralList',
      params: {
        'page': page,
        'page_size': limit,
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index) {
      return RecordModel.fromJson(result.data['list'][index]);
    });
  }

  /// 7、讨论
  ///
  static Future<List<CourseModel>> discuss({
    int page = 1,
    int limit = 10,
  }) async {
    final result = await HttpService.to.post(
      '/v1/members/Information/myComment',
      params: {
        'page': page,
        'page_size': limit,
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index) {
      return CourseModel.fromJson(result.data['list'][index]);
    });
  }

  /// 8、优惠券列表
  ///
  static Future<List<CouponModel>> coupon({
    int page = 1,
    int limit = 10,
    required int type,
  }) async {
    final result = await HttpService.to.post(
      '/v1/coupon/Coupon/getCouponRecordListSAll',
      params: {'page': page, 'page_size': limit, 'type': type},
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index) {
      return CouponModel.fromJson(result.data['list'][index]);
    });
  }

  /// 9、获取最新版本
  ///
  static Future<UModel> update() async {
    final result = await HttpService.to.post(
      '/v1/members/Information/getVersion',
      params: {},
    );
    if (result.data is! Map) return UModel();
    return UModel.fromJson(result.data);
  }

  /// 10、版本介绍
  static Future<List<VersionModel>> versions({
    int page = 1,
    int limit = 10,
  }) async {
    final result = await HttpService.to.post(
      '/v1/members/Information/getAllVersionList',
      params: {
        'page': page,
        'page_size': limit,
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index) {
      return VersionModel.fromJson(result.data['list'][index]);
    });
  }

  /// 11、修改用户信息
  ///
  static Future<bool> changeInfo(
      {String? name, num? sex, String? headImg}) async {
    Map<String, dynamic> params = {};
    if (name != null) {
      params['name'] = name;
    }
    if (sex != null) {
      params['sex'] = sex;
    }
    if (headImg != null) {
      params['head_img'] = headImg;
    }
    final result = await HttpService.to
        .post('/v1/members/Information/editInformation', params: params);
    if (result.data is Map && result.data['is_success'] == 1) {
      return true;
    }
    return false;
  }

  /// 12、笔记详情列表
  ///
  static Future<List<NoteModel>> noteList(
      {int page = 1,
      int limit = 10,
      required String bookId,
      required String types}) async {
    final result = await HttpService.to.post(
      '/v1/members/Information/myBookNotes',
      params: {
        'page': page,
        'page_size': limit,
        'book_id': bookId,
        'types': types
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index) {
      return NoteModel.fromJson(result.data['list'][index]);
    });
  }

  /// 13、笔记详情列表
  ///
  static Future<List<DiscussModel>> discussList(
      {int page = 1,
      int limit = 10,
      required String bookId,
      required String types}) async {
    final result = await HttpService.to.post(
      '/v1/members/Information/myBookComment',
      params: {
        'page': page,
        'page_size': limit,
        'book_id': bookId,
        'types': types
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index) {
      return DiscussModel.fromJson(result.data['list'][index]);
    });
  }

  /// 14、修改密码
  ///
  static Future<bool> changePwd(
      {required String password, required String rePassword}) async {
    final result = await HttpService.to.post(
      '/v1/members/Information/changePasswd',
      params: {'password': password, 'repassword': rePassword},
    );
    if (result.data is Map && result.data['is_success'] == 1) {
      return true;
    }
    return false;
  }

  /// 15、修改手机号
  static Future<bool> changePhone(
      {required String phone, required String code}) async {
    final result = await HttpService.to.post(
      '/v1/members/Information/editPhone',
      params: {'phone': phone, 'code': code},
    );
    if (result.data is Map && result.data['is_success'] == 1) {
      return true;
    }
    return false;
  }

  /// 16、帮助中心
  static Future<List<HelpCenterModel>> helpCenters({
    int page = 1,
    int limit = 10,
  }) async {
    final result = await HttpService.to.post(
      '/v1/common/Help/getList',
      params: {
        'page': page,
        'page_size': limit,
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index) {
      return HelpCenterModel.fromJson(result.data['list'][index]);
    });
  }

  /// 17、帮助中心内容
  static Future<HelpCenterContentModel> helpCenterContent(String id) async {
    final result = await HttpService.to.post(
      '/v1/common/Help/getInfoById',
      params: {
        'id': id,
      },
    );
    if (result.data is! Map) return HelpCenterContentModel();
    return HelpCenterContentModel.fromJson(result.data);
  }


  /// 18、意见反馈
  ///
  static Future<bool> feedback(String? proposal) async {
    Map<String, dynamic> params = {};
    if (proposal != null) {
      params['proposal'] = proposal;
    }
    final result = await HttpService.to
        .post('/v1/members/Information/proposal', params: params);
    if (result.data is Map && result.data['is_success'] == 1) {
      return true;
    }
    return false;
  }
}
