part of library;

class FilterPage extends StatefulWidget {
  final LibraryController controller;
  final void Function() sureTap;
  final void Function() resetTap;
  const FilterPage({
    Key? key,
    required this.sureTap,
    required this.resetTap,
    required this.controller
  }) : super(key: key);

  @override
  State<FilterPage> createState() => _FilterPageState();
}

class _FilterPageState extends State<FilterPage> {
  @override
  Widget build(BuildContext context) {
    List<FilterModel> categories = widget.controller.categories.map((model) {
      return FilterModel(id: model.categoryId.toString(), name: model.name??'');
    }).toList();

    List<FilterModel> labels = widget.controller.labels.map((model) {
      return FilterModel(id: model.labelId.toString(), name: model.name??'');
    }).toList();

    return Container(
      color: const Color(0xFF000000).withOpacity(0.5),
      child: Column(
        children: [
          Container(
            color: Colors.white,
            width: double.infinity,
            padding: EdgeInsets.only(bottom: 10.w),
            child: Column(
              children: [
                Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    _buildWrapWidget('分类', categories),
                    _buildWrapWidget('标签', labels),
                    _buildWrapWidget('是否收费', [FilterModel(id: '0', name: '收费'),FilterModel(id: '1', name: '免费')]),
                    _buildWrapWidget('排序', [FilterModel(id: '0', name: '读过'),FilterModel(id: '1', name: '评分')]),
                  ],
                )
              ],
            ),

          ),
          Container(
            padding: EdgeInsets.only(left:10.w,right:10.w,top:30.w,bottom:10.w),
            color: Colors.white,
            // margin: const EdgeInsets.symmetric(horizontal: 15),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceEvenly,
              children: [
                Expanded(
                  child: GestureDetector(
                    onTap: widget.resetTap,
                    child: Container(
                      alignment: Alignment.center,
                      height: 35.w,
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(17.5.w),
                        border:Border.all(
                            width: 0.5.w,
                            color: Colours.c9
                        ),
                        // color: Colours.cE0.withOpacity(0.5),
                      ),
                      // padding: EdgeInsets.symmetric(vertical: 8),
                      child: Text('重置',style: TextStyle(fontSize: 13.w,color: Colours.c9,height: 1.5),),
                    ),
                  ),
                ),
                Gaps.hGaps10,
                Expanded(
                  child: GestureDetector(
                    onTap: widget.sureTap,
                    child: Container(
                      decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(17.5.w),
                          color: AppTheme.primary.withOpacity(0.1)
                      ),
                      height: 35.w,
                      alignment: Alignment.center,
                      padding: EdgeInsets.symmetric(vertical: 8.w),
                      child: Text('确定',style: TextStyle(fontSize: 13.w,color: AppTheme.primary,height: 1.5),),
                    ),
                  ),
                )
              ],
            ),
          )
        ],
      ),
    );
  }

  Widget _buildWrapWidget(String title,List<FilterModel> data){

    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Container(
            margin: EdgeInsets.only(left: 10,bottom: 10,top: 10),
            child: Text(title,style: TextStyle(fontSize: 15,height:1.6,color: Colours.c3,fontWeight: Fonts.medium),)
        ),
        Wrap(
          spacing: 10,
          runSpacing: 10,
          alignment: WrapAlignment.start,
          runAlignment: WrapAlignment.start,
          children: data.map((model){
            return GestureDetector(
              onTap: (){
                print('================================');
                setState(() {
                  print('--------------------------------${model.selected}');
                  model.selected = !model.selected;
                });
              },
              child: Container(
                height: 27,
                decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(13.5),
                    color: model.selected?AppTheme.primary: Colours.cF4
                ),
                child: Padding(
                  padding: const EdgeInsets.symmetric(horizontal:15,vertical: 5),
                  child: model.name == '读过' || model.name == '评分'?Row(
                    mainAxisSize: MainAxisSize.min,
                    children: [
                      Text(model.name,style: TextStyle(fontSize: 13,height: 1.4,color: model.selected?AppTheme.primary: Colours.c3),textAlign: TextAlign.center,),
                      Image.asset('assets/images/down.png'),
                    ],
                  ):Text(model.name,style: TextStyle(fontSize: 13,height: 1.4,color: model.selected?AppTheme.primary: Colours.c3),textAlign: TextAlign.center,),
                ),
              ),
            );
          }).toList(),
        )
      ],
    );
  }
}
