part of user_security;

class UserSecurityPage extends StatefulWidget {
  final UserInfoModel model;

  const UserSecurityPage({Key? key, required this.model}) : super(key: key);

  @override
  State<UserSecurityPage> createState() => _UserSecurityPageState();
}

class _UserSecurityPageState extends State<UserSecurityPage> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        centerTitle: true,
        title: const Text('账号安全'),
      ),
      body: Column(
        children: [
          Container(
            margin: EdgeInsets.symmetric(vertical: 10.w, horizontal: 10.w),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(8.w),
              color: Colors.white,
              boxShadow: [
                BoxShadow(
                  color: const Color(0xFFC7C7C7).withOpacity(0.5),
                  offset: Offset(3.w, 0),
                  blurRadius: 10.w,
                  spreadRadius: 0.w,
                ),
              ],
            ),
            child: Column(
              children: [
                GestureDetector(
                    onTap: () {
                      context.pushNamed(Routes.changePhone);
                    },
                    child: _buildItem(
                        title: '修改手机号码', value: widget.model.phone ?? '')),
                Container(
                  margin: EdgeInsets.symmetric(horizontal: 10.w),
                  height: 0.5.w,
                  color: Colours.cF0,
                ),
                GestureDetector(
                    onTap: () {
                      context.pushNamed(Routes.changePwd, extra: widget.model);
                    },
                    child: _buildItem(
                        title: '修改密码',
                        value: widget.model.password.toString().isEmpty
                            ? '未设置'
                            : '')),
              ],
            ),
          ),
          Container(
            margin: EdgeInsets.symmetric(horizontal: 10.w),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(8.w),
              color: Colors.white,
              boxShadow: [
                BoxShadow(
                  color: const Color(0xFFC7C7C7).withOpacity(0.5),
                  offset: Offset(3.w, 0),
                  blurRadius: 10.w,
                  spreadRadius: 0.w,
                ),
              ],
            ),
            child: Column(
              children: [
                GestureDetector(
                  child: _buildItem(title: '账号注销', value: ''),
                  onTap: () async {
                    showDialog(
                      context: context,
                      builder: (BuildContext context) {
                        return AlertDialog(
                          shape: RoundedRectangleBorder(
                            borderRadius: BorderRadius.circular(8.0.w),
                          ),
                          contentPadding: EdgeInsets.zero,
                          // 移除内容部分的内边距
                          content: Wrap(
                            children: [
                              Container(
                                margin:
                                    EdgeInsets.only(top: 44.w, bottom: 29.w),
                                // 调整上下间距
                                child: Center(
                                  child: Text(
                                    '确定注销账号吗',
                                    style: TextStyle(
                                      fontSize: 15.w,
                                      fontWeight: Fonts.medium,
                                      color: Colours.c3,
                                    ),
                                  ),
                                ),
                              ),
                              Container(
                                height: 1.w, // 设置分割线的高度
                                width: double.infinity, // 设置分割线的宽度
                                color: Colours.cLine, // 设置分割线的颜色
                              ),
                            ],
                          ),
                          // 去除操作按钮区域的内边距
                          actionsPadding: EdgeInsets.zero,
                          actions: <Widget>[
                            Row(
                              mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                              children: [
                                GestureDetector(
                                  onTap: () => Navigator.of(context).pop(),
                                  child: Container(
                                    width: 105.w,
                                    color: Colours.cFF,
                                    alignment: Alignment.center,
                                    child: const Text(
                                      '取消',
                                      style: TextStyle(
                                        fontSize: 12,
                                        fontWeight: Fonts.medium,
                                        color: Colours.c6,
                                      ),
                                    ),
                                  ),
                                ),
                                Container(
                                  height: 39.5.w, // 设置分割线的高度
                                  width: 1, // 设置分割线的宽度
                                  color: Colours.cLine, // 设置分割线的颜色
                                ),
                                GestureDetector(
                                  onTap: () async {
                                    final result = await AccountAPI.delete();
                                    if (result) {
                                      CustomToast.loading();
                                      await UserStore.to.logout();
                                      CustomToast.dismiss();
                                      if (context.mounted) {
                                        context.goNamed(Routes.splash);
                                      }
                                    }
                                  },
                                  child: Container(
                                    width: 105.w,
                                    color: Colours.cFF,
                                    alignment: Alignment.center,
                                    child: const Text(
                                      '确定',
                                      style: TextStyle(
                                        fontSize: 12,
                                        fontWeight: Fonts.medium,
                                        color: Colours.cAB1941,
                                      ),
                                    ),
                                  ),
                                ),
                              ],
                            ),
                          ],
                        );
                      },
                    );
                  },
                ),
              ],
            ),
          )
        ],
      ),
    );
  }

  Widget _buildItem({required String title, required String value}) {
    return Container(
      margin: EdgeInsets.only(left: 15.w, right: 15.w),
      color: Colors.white,
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          GestureDetector(
            onTap: () async {},
            child: Container(
              color: Colors.white,
              height: 45.w,
              alignment: Alignment.centerLeft,
              child: Text(title,
                  style: TextStyle(
                      fontSize: 13.w, height: 1.5, color: Colours.c3)),
            ),
          ),
          Row(
            children: [
              Text(
                value,
                style:
                    TextStyle(fontSize: 13.w, height: 1.5, color: Colours.c9),
              ),
              Gaps.hGaps10,
              Image.asset('assets/images/right_arrow.png')
            ],
          )
        ],
      ),
    );
  }
}
