part of apis;

abstract class MineAPI {

  /// 1、个人信息以及8个数据
  ///
  static Future <Map<String,dynamic>> userInfo() async {
    final result = await HttpService.to.post(
      '/v1/members/Information/getMyStatistics',
      params: {},
    );
    if (result.data is! Map ) return {};
    return result.data;
  }

  /// 2、我的收藏
  static Future <List<CourseModel>> love({
    int page = 1,
    int limit = 10,
  }) async {
    final result = await HttpService.to.post(
      '/v1/members/Information/myCollection',
      params: {
        'page': page,
        'pageSize': limit,
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return CourseModel.fromJson(result.data['list'][index]);
    });
  }

  /// 3、笔记
  ///
  static Future <List<CourseModel>> note({
    int page = 1,
    int limit = 10,
  }) async {
    final result = await HttpService.to.post(
      '/v1/members/Information/myNotes',
      params: {
        'page': page,
        'pageSize': limit,
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return CourseModel.fromJson(result.data['list'][index]);
    });
  }

  static Future <List<CourseModel>> wrong({
    int page = 1,
    int limit = 10,
  }) async {
    final result = await HttpService.to.post(
      '/v1/members/Information/myWrongQuestion',
      params: {
        'page': page,
        'pageSize': limit,
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return CourseModel.fromJson(result.data['list'][index]);
    });
  }



}