part of search;

class SearchPage extends StatefulWidget {
  const SearchPage({Key? key}) : super(key: key);

  @override
  State<SearchPage> createState() => _SearchPageState();
}

class _SearchPageState extends State<SearchPage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<SearchController>(
      init: SearchController(),
      builder:(controller)=> Scaffold(
        appBar: CustomAppBar(
          automaticallyImplyLeading:false,
          titleSpacing: 0,
          title:  Padding(
            padding:  const EdgeInsets.symmetric(horizontal: AppTheme.margin),
            child: CustomInputSearch(
              controller: controller.searchController,
              readOnly:false,
              hintText: '请输入书籍名称',
              onTap: () {
                // context.pushNamed(Routes.msgs);
              },
              onEditingComplete: (){
                controller.search();
              },
            ),
          ),
          actions: [
            GestureDetector(
              onTap: (){
                context.pop();
              },
              child: Container(
                padding: const EdgeInsets.only(left: 10,top: 10,bottom: 10),
                  child: const Text('取消',style: TextStyle(fontSize: 14,height: 1.5,color: Colours.c3),),
                // color: Colors.red,
              ),
            )
          ],
        ),
        body: BuildHistory(controller: controller),
      ),
    );
  }
}
