part of user_notes;

class UserNotePage extends StatefulWidget {
  const UserNotePage({Key? key}) : super(key: key);

  @override
  State<UserNotePage> createState() => _UserNotePageState();
}

class _UserNotePageState extends State<UserNotePage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<UserNoteController>(
      init: UserNoteController(),
      builder:(controller)=> Scaffold(
        appBar: AppBar(
          centerTitle: true,
          title: const Text('笔记'),
        ),
        body: Container(
          margin: const EdgeInsets.all(10),
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(8),
            // color: Colors.yellow,
            boxShadow: [
              BoxShadow(
                color: const Color(0xFFC7C7C7).withOpacity(0.5),
                offset: const Offset(3, 0),
                blurRadius: 10.w,
                spreadRadius: 0.w,
              ),
            ],
          ),
          child: CustomPullScrollView(
            controller: controller.refreshController,
            onRefresh: controller.onRefresh,
            onLoading: controller.onLoading,
            child: SingleChildScrollView(
              child: Column(
                children: [
                  Container(
                    padding: const EdgeInsets.only(left: 10),
                    height: 32,
                    width: double.infinity,
                    decoration: const BoxDecoration(
                      borderRadius: BorderRadius.only(
                        topLeft: Radius.circular(8),
                        topRight: Radius.circular(8),
                      ),
                      color: Colors.white,
                    ),
                    alignment: Alignment.centerLeft,
                    child: Text('共${controller.notes.length}本书',style: const TextStyle(fontSize: 13,height: 1.5,color: Colours.c6),),
                  ),
                  ListView.builder(
                    physics: const NeverScrollableScrollPhysics(),
                    shrinkWrap: true,
                    itemBuilder: (BuildContext context, int index){
                      return BuildItem(model: controller.notes[index],);
                    },
                    itemCount: controller.notes.length,
                  )
                ],
              ),
            ),
          ),
        ),
      ),
    );
  }
}
