part of book_shop;

class BookCell extends StatelessWidget {
  final CourseModel model;
  final void Function() delTap;
  const BookCell({
    super.key,
    required this.model,
    required this.delTap
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: BoxDecoration(
          borderRadius:BorderRadius.circular(5.w),
          color: Colors.white,
          boxShadow: [
            BoxShadow(
              color: model.selected?AppTheme.primary.withOpacity(0.21):const Color(0xFFC7C7C7).withOpacity(0.5),
              spreadRadius: 0.w,
              blurRadius: 10.w,
              offset: Offset(3.w, 0), // changes the position of the shadow
            ),
          ],
          border:model.selected?Border.all(width: 0.5.w,color: AppTheme.primary):null,
      ),
      margin: EdgeInsets.only(left: 10.w,right: 10.w,top: 10.w),
      height: 110.w,
      child: Slidable(
        endActionPane: ActionPane(
          motion: const ScrollMotion(),
          children: [
            SlidableAction(
              // An action can be bigger than the others.
              onPressed: (BuildContext context){
                delTap;
              },
              backgroundColor: AppTheme.primary,
              foregroundColor: Colors.white,
              // icon: Icons.archive,
              label: '删除',
            ),
          ],
        ),
        child: Row(
         children: [
           ///左侧
           Container(
             margin: EdgeInsets.only(left: 12.w,right: 11.w),
             child: Row(
               children: [
                SizedBox(
                   height: 17.w,
                   width: 17.w,
                   // color: Colors.cyan,
                   child:  Image.asset(model.selected?'assets/images/pay_check.png':'assets/images/pay_uncheck.png'),
                 ),
                 SizedBox(width: 12.w,),
                 CustomCard(
                   width: 72.w,
                   height: 86.w,
                   url: model.img??'',
                 )
               ],
             ),
           ),
           ///右侧
           Expanded(
             child: Container(
               padding: EdgeInsets.only(top: 12.w,bottom: 10.w),
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(model.bookName??'',style: TextStyle(fontSize: 13.w,fontWeight: Fonts.medium,color: Colours.c3),maxLines: 2,overflow: TextOverflow.ellipsis,),
                        SizedBox(height: 5.w,),
                        Text(model.authors??'',style:  TextStyle(fontSize: 11.w,color: Colours.c9)),
                      ],
                    ),
                    Text('￥${model.vipPrice??''}',style: TextStyle(fontSize: 14.w,fontWeight: FontWeight.w500,color: AppTheme.primary)),
                  ],
                ),
             ),
           )
         ],
        ),
      )
    );
  }
}
