part of mine;


class MinePage extends StatefulWidget {
  const MinePage({Key? key}) : super(key: key);

  @override
  State<MinePage> createState() => _MinePageState();
}

class _MinePageState extends State<MinePage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<MineController>(
      init: MineController(),
        builder:(controller) => Stack(
          children: [
            Image.asset(
                'assets/images/mine_bg.png',
              fit: BoxFit.contain,
              width: double.infinity,
            ),
            Scaffold(
              backgroundColor:Colors.transparent,
              appBar: CustomAppBar(
                backgroundColor: Colors.transparent,
                actions: [
                  CustomButton.icon(
                    padding: EdgeInsets.zero,
                    backgroundColor: Colors.transparent,
                    icon: Image.asset(
                      'assets/images/read_history.png',
                    ),
                    onPressed: () => context.pushNamed(Routes.studyHistory),
                  ),
                  CustomButton.icon(
                    padding: EdgeInsets.zero,
                    backgroundColor: Colors.transparent,
                    icon: Image.asset(
                      'assets/images/set.png',
                    ),
                    onPressed: () => context.pushNamed(Routes.set),
                  ),
                  GestureDetector(
                    onTap: () async{
                      final result = await context.pushNamed(Routes.msgs);
                      print('---------------------------------1111$result');
                      if (result == true){
                        controller.getNums();
                      }
                    },
                    child: badges.Badge(
                      position: badges.BadgePosition.topEnd(top: -5, end: 0),
                      showBadge: controller.num == 0?false:true,
                      badgeContent: Text(controller.num.toString(),style: const TextStyle(fontSize: 7,color: Colors.white),),
                      badgeStyle: const badges.BadgeStyle(
                          badgeColor: AppTheme.primary,
                          shape: badges.BadgeShape.circle
                      ),
                      child: CustomButton.icon(
                        padding: EdgeInsets.zero,
                        backgroundColor: Colors.transparent,
                        icon: Image.asset(
                          'assets/images/msg_black.png',
                        ),
                        // onPressed: () => context.pushNamed(Routes.msgs),
                      ),
                    ),
                  )
                ],
              ),
              body: Container(
                color: Colors.transparent,
                child: SingleChildScrollView(
                  child: Column(
                    children: [
                      Container(
                        margin: EdgeInsets.symmetric(horizontal: 10.w),
                        child: BuildUser(userInfo:controller.userInfo,onTap: () async{
                          final result =  await context.pushNamed(Routes.userInfo,extra: controller.userInfo);
                          if (result == true){
                            controller.getInfo();
                          }
                        },),
                      ),
                      Gaps.vGaps10,
                      Container(
                        margin: EdgeInsets.symmetric(horizontal: 2.2.w),
                        child: BuildRead(items: controller.reads,onTap: (ReadModel model) async{
                          final result =  await context.pushNamed(model.link??'');
                          if (result == true){
                            controller.getInfo();
                          }
                        }),
                      ),
                      controller.ads.isNotEmpty?Gaps.vGaps10:const SizedBox(),
                      controller.ads.isNotEmpty?
                      Container(
                        color: Colors.transparent,
                        padding: EdgeInsets.symmetric(horizontal: 10.w),
                        child: BuildBanner(
                          items:controller.ads,
                          onTap:(adModel){
                            context.pushNamed(Routes.adDetail,extra: adModel);
                          } ,
                        ),
                      ):const SizedBox(),
                      Gaps.vGaps5,
                      BuildAccount(items:controller.accounts,onTap: (ReadModel model) async{
                        final result =  await context.pushNamed(model.link??'');
                        if (result == true){
                          controller.getInfo();
                        }
                      },),
                      Gaps.vGaps10,
                      Container(
                        margin: EdgeInsets.symmetric(horizontal: AppTheme.margin),
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(8.w),
                          color: Colors.white,
                          boxShadow: [
                            BoxShadow(
                              color:  const Color(0xFFC7C7C7).withOpacity(0.5),
                              offset: Offset(3.w, 0),
                              blurRadius: 10.w,
                              spreadRadius: 0.w,
                            ),
                          ],
                        ),
                        child: ClipRRect(
                          borderRadius: BorderRadius.circular(8.w),
                          child: Column(
                            children: [
                              GestureDetector(
                                onTap:(){
                                  context.pushNamed(Routes.security,extra: controller.userInfo);
                                }, child: _buildItem('账户安全')
                              ),
                              Container(color: Colours.cLine,margin: EdgeInsets.symmetric(horizontal: 15.w),height: 1.w,),
                              // _buildItem('意见反馈'),
                              GestureDetector(
                                  onTap:(){
                                    context.pushNamed(Routes.feedback);
                                  }, child: _buildItem('意见反馈')
                              ),
                              Container(color: Colours.cLine,margin: EdgeInsets.symmetric(horizontal: 15.w),height: 1.w,),
                              GestureDetector(
                                  onTap: (){
                                    context.pushNamed(Routes.helpCenter);
                                  }, child: _buildItem('帮助中心',)
                              ),
                              Container(color: Colours.cLine,margin: EdgeInsets.symmetric(horizontal: 15.w),height: 1.w,),
                              GestureDetector(
                                onTap: (){
                                  context.pushNamed(Routes.about);
                                }, child: _buildItem('关于我们',)
                              ),
                            ],
                          ),
                        ),
                      ),
                    ],
                  ),
                ),
              ),
            )
          ],
        ),
    );
  }

  Widget _buildItem(String title) {
    return Container(
      padding:  EdgeInsets.only(left: 18.w,right: 15.w),
      color: Colors.white,
      height: 42.w,
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          Text(title,style: TextStyle(fontSize: 14.w,color: Colours.c3,),),
          SizedBox(
            width: 5.w,
            height: 8.w,
            child: Image.asset('assets/images/right_arrow.png'),
          )
        ],
      ),
    );
  }

}
