part of models;

/// book_id : 2
/// book_name : "五禽戏"
/// authors : "华佗"
/// img : "https://resource.vning.net/book/img/vning_hEBkC8RG26_1646976647301.jpg"
/// progress : "0%"

class CourseModel {
  CourseModel({
      this.bookId, 
      this.bookName, 
      this.authors, 
      this.img, 
      this.progress,
      this.lastChapter,
      this.createTime,
      this.days,
      this.readNum,
      this.isCollection
  });

  CourseModel.fromJson(dynamic json) {
    bookId = json['book_id'];
    bookName = json['book_name'];
    authors = json['authors'];
    img = json['img'];
    progress = json['progress'];
    lastChapter = json['lastChapter'];
    createTime = json['create_time'];
    days = json['days'];
    readNum = json['read_num'];
    isCollection = json['is_collection'];

  }
  num? bookId;
  String? bookName;
  String? authors;
  String? img;
  String? progress;
  String? lastChapter;
  String? createTime;
  String? days;
  String? introduction;
  num? readNum;
  num? isCollection;


  int get type {
    if (progress == '0.00%'){
      return 0;
    } else if (progress == '100.00%'){
      return 1;
    } else {
      return 2;
    }
  }

  String get typeName {
    if (progress == '0.00%'){
      return '未学习';
    } else if (progress == '100.00%'){
      return '已学完';
    } else {
      return '已学习$progress';
    }
  }

  CourseModel copyWith({  num? bookId,
    String? bookName,
    String? authors,
    String? img,
    String? progress,
    String? lastChapter,
    String? createTime,
    String? days,
    num? readNum,
    num? isCollection,

  }) => CourseModel(  bookId: bookId ?? this.bookId,
    bookName: bookName ?? this.bookName,
    authors: authors ?? this.authors,
    img: img ?? this.img,
    progress: progress ?? this.progress,
    lastChapter: lastChapter ?? this.lastChapter,
    createTime: createTime ?? this.createTime,
    days: days ?? this.days,
    readNum: readNum ?? this.readNum,
    isCollection: isCollection ?? this.isCollection
  );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['book_id'] = bookId;
    map['book_name'] = bookName;
    map['authors'] = authors;
    map['img'] = img;
    map['progress'] = progress;
    map['lastChapter'] = lastChapter;
    map['create_time'] = createTime;
    map['days'] = days;
    map['read_num'] = readNum;
    map['is_collection'] = isCollection;
    return map;
  }

}