part of course;

class Book extends StatelessWidget {
  final CourseModel model;
  const Book({
    Key? key,
    required this.model
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(8),
        color: const Color(0xFFF9F9F9),
        boxShadow: [
          BoxShadow(
            color: const Color(0xFFC7C7C7).withOpacity(0.5),
            offset: const Offset(3, 0),
            blurRadius: 10.w,
            spreadRadius: 0.w,
          ),
        ],
      ),
      margin: const EdgeInsets.only(right: 13),
      padding: const EdgeInsets.only(left: 10,right: 10,bottom: 13.5,top: 16.5),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          Expanded(
            child: AspectRatio(
              aspectRatio: 0.85,
              child: Container(
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(3),
                  color: Colors.white,
                  boxShadow: [
                    BoxShadow(
                      color: const Color(0xFF707070).withOpacity(0.5),
                      offset: const Offset(0, 0),
                      blurRadius: 4.5.w,
                      spreadRadius: 0.w,
                    ),
                  ],
                ),
                padding: EdgeInsets.all(1),
                child: Container(
                  // margin: const EdgeInsets.only(top: 16,bottom: 10),
                  // color: Colors.red,
                  child: Image.network(model.img.toString()),
                  // width: 85,
                ),
              ),
            ),
          ),
          Gaps.vGaps10,
          SizedBox(
            width: double.infinity,
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Text(model.bookName??'',style: const TextStyle(fontSize: 13,height: 1.5,color: Colours.c3),maxLines: 1,overflow: TextOverflow.ellipsis,),
                Text(model.authors ??'',style: const TextStyle(fontSize:12,height: 1.3,color: Colours.c6,),textAlign: TextAlign.left,),
              ],
            ),
          ),
          Gaps.vGaps5,
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Container(
                color: model.type ==0||model.type ==1 ?Colours.cEF :AppTheme.primary.withOpacity(0.1),
                padding: const EdgeInsets.symmetric(horizontal: 3.5),
                child: Text(model.typeName,style: TextStyle(fontSize: 11,height: 1.3,color: model.type ==0||model.type ==1 ?Colours.c9:AppTheme.primary),),
              ),
              model.type == 2? const Text('继续学习',style: TextStyle(fontSize: 11,height: 1.3,color: AppTheme.primary,fontWeight: Fonts.medium),):const SizedBox()
            ],
          )
        ],
      ),
    );
  }
}
