part of study_history;
class HistoryController extends GetxController {

  final EasyRefreshController refreshController = EasyRefreshController(
    controlFinishLoad: true,
    controlFinishRefresh: true,
  );

  // 学习历史数组
  List<StudyHistoryModel> histories = [];

  final int _limit = 10;
  int _page = 1;
  bool _noMore = false;


  @override
  void onClose() {
    refreshController.dispose();
    super.onClose();
  }


  /// 获取 最近学习数据
  Future<void> _getHistory([bool isRefresh = false]) async {
    if (isRefresh) _page = 1;
    // 网路请求
    final result = await CommonAPI.history(
        page: _page,
        limit: _limit
    );

    print('11111111111111111111111111$result');
    // 如果是刷新 清理数据
    if (isRefresh) histories.clear();
    histories.addAll(result);
    _page ++;
    _noMore = result.length < _limit;
    update();

  }

  void onRefresh() async {
    try {
      await _getHistory(true);
      refreshController.finishRefresh(IndicatorResult.success);
      refreshController.resetFooter();
    } catch (error) {
      refreshController.finishRefresh(IndicatorResult.fail);
    }
  }

  void onLoading() async {
    if (_noMore) {
      refreshController.finishLoad(IndicatorResult.noMore);
      return;
    }
    try {
      await _getHistory();
      refreshController.finishLoad();
    } catch (error) {
      refreshController.finishLoad(IndicatorResult.fail);
    }
  }

}