part of models;
/// 1、----------------------------图书分类模型----------------------------
///
class CategoryModel {
  CategoryModel({
    this.categoryId,
    this.name,
    this.selected = false,
  });

  CategoryModel.fromJson(dynamic json) {
    categoryId = json['category_id'];
    name = json['name'];
    selected = false;
  }
  num? categoryId;
  String? name;
  late bool selected;
  CategoryModel copyWith({  num? categoryId,
    String? name,
  }) => CategoryModel(  categoryId: categoryId ?? this.categoryId,
    name: name ?? this.name,
  );
  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['category_id'] = categoryId;
    map['name'] = name;
    return map;
  }
}


/// 2、----------------------------图书标签模型----------------------------
///
class LabelModel {
  LabelModel({
    this.labelId,
    this.name,
    this.selected = false,
  });

  LabelModel.fromJson(dynamic json) {
    labelId = json['label_id'];
    name = json['name'];
    selected = false;
  }
  num? labelId;
  String? name;
  late bool selected;
  LabelModel copyWith({  num? labelId,
    String? name,
  }) => LabelModel(  labelId: labelId ?? this.labelId,
    name: name ?? this.name,
  );
  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['label_id'] = labelId;
    map['name'] = name;
    return map;
  }

}

/// 3、----------------------------书籍评价模型----------------------------
///

class ScoreModel {
  ScoreModel({
    this.bookCommentId,
    this.comments,
    this.rating,
    this.createTime,
    this.membersId,
    this.users,
    this.usersImg,});

  ScoreModel.fromJson(dynamic json) {
    bookCommentId = json['book_comment_id'];
    comments = json['comments'];
    rating = json['rating'];
    createTime = json['create_time'];
    membersId = json['members_id'];
    users = json['users'];
    usersImg = json['users_img'];
  }
  num? bookCommentId;
  String? comments;
  num? rating;
  String? createTime;
  num? membersId;
  String? users;
  String? usersImg;

  ScoreModel copyWith({  num? bookCommentId,
    String? comments,
    num? rating,
    String? createTime,
    num? membersId,
    String? users,
    String? usersImg,
  }) => ScoreModel(  bookCommentId: bookCommentId ?? this.bookCommentId,
    comments: comments ?? this.comments,
    rating: rating ?? this.rating,
    createTime: createTime ?? this.createTime,
    membersId: membersId ?? this.membersId,
    users: users ?? this.users,
    usersImg: usersImg ?? this.usersImg,
  );
  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['book_comment_id'] = bookCommentId;
    map['comments'] = comments;
    map['rating'] = rating;
    map['create_time'] = createTime;
    map['members_id'] = membersId;
    map['users'] = users;
    map['users_img'] = usersImg;
    return map;
  }

}

/// 4、----------------------------章节模型----------------------------
///
class ChapterModel {
  ChapterModel({
    this.id,
    this.name,
    this.pid,
    this.bookId,
    this.isReading,
    this.sort,
    this.seen,
    this.children,
    this.selected = false
  });

  ChapterModel.fromJson(dynamic json) {
    id = json['id'];
    name = json['name'];
    pid = json['pid'];
    bookId = json['book_id'];
    isReading = json['is_reading'];
    sort = json['sort'];
    seen = json['seen'];
    if (json['children'] != null) {
      children = [];
      json['children'].forEach((v) {
        children?.add(ChapterModel.fromJson(v));
      });
    }
    selected = false;
  }
  num? id;
  String? name;
  num? pid;
  num? bookId;
  num? isReading;
  num? sort;
  num? seen;
  late bool selected;
  List<ChapterModel>? children;
  ChapterModel copyWith({  num? id,
    String? name,
    num? pid,
    num? bookId,
    num? isReading,
    num? sort,
    num? seen,
    List<ChapterModel>? children,
  }) => ChapterModel(  id: id ?? this.id,
    name: name ?? this.name,
    pid: pid ?? this.pid,
    bookId: bookId ?? this.bookId,
    isReading: isReading ?? this.isReading,
    sort: sort ?? this.sort,
    seen: seen ?? this.seen,
    children: children ?? this.children,
  );
  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['name'] = name;
    map['pid'] = pid;
    map['book_id'] = bookId;
    map['is_reading'] = isReading;
    map['sort'] = sort;
    map['seen'] = seen;
    if (children != null) {
      map['children'] = children?.map((v) => v.toJson()).toList();
    }
    return map;
  }

}

/// 5、----------------------------图书详细模型----------------------------
///
class BookDetailModel {
  BookDetailModel({
    this.bookId,
    this.bookName,
    this.img,
    this.price,
    this.vipPrice,
    this.rating,
    this.readNum,
    this.content,
    this.isFree,
    this.authors,
    this.onsaleTime,
    this.categoryId,
    this.pressId,
    this.producersId,
    this.isHave,
    this.isCollection,
    this.ratingCount,
    this.ratingList,
    this.categoryName,
    this.pressName,
    this.producersName,
    this.chapterId,
    this.chapterName,
    this.readChapterId,
  });

  BookDetailModel.fromJson(dynamic json) {
    bookId = json['book_id'];
    bookName = json['book_name'];
    img = json['img'];
    price = json['price'];
    vipPrice = json['vip_price'];
    rating = json['rating'];
    readNum = json['read_num'];
    content = json['content'];
    isFree = json['is_free'];
    authors = json['authors'];
    onsaleTime = json['onsale_time'];
    categoryId = json['category_id'];
    pressId = json['press_id'];
    producersId = json['producers_id'];
    isHave = json['is_have'];
    isCollection = json['is_collection'];
    ratingCount = json['rating_count'];
    ratingList = json['rating_list'] != null ? json['rating_list'].cast<num>() : [];
    categoryName = json['category_name'];
    pressName = json['press_name'];
    producersName = json['producers_name'];
    chapterId = json['chapter_id'];
    chapterName = json['chapter_name'];
    readChapterId = json['read_chapter_id'];
  }
  num? bookId;
  String? bookName;
  String? img;
  String? price;
  String? vipPrice;
  String? rating;
  num? readNum;
  String? content;
  num? isFree;
  String? authors;
  num? onsaleTime;
  num? categoryId;
  num? pressId;
  num? producersId;
  num? isHave;
  num? isCollection;
  num? ratingCount;
  List<num>? ratingList;
  String? categoryName;
  String? pressName;
  String? producersName;
  num? chapterId;
  String? chapterName;
  num? readChapterId;
  BookDetailModel copyWith({  num? bookId,
    String? bookName,
    String? img,
    String? price,
    String? vipPrice,
    String? rating,
    num? readNum,
    String? content,
    num? isFree,
    String? authors,
    num? onsaleTime,
    num? categoryId,
    num? pressId,
    num? producersId,
    num? isHave,
    num? isCollection,
    num? ratingCount,
    List<num>? ratingList,
    String? categoryName,
    String? pressName,
    String? producersName,
    num? chapterId,
    String? chapterName,
    num? readChapterId,
  }) => BookDetailModel(  bookId: bookId ?? this.bookId,
    bookName: bookName ?? this.bookName,
    img: img ?? this.img,
    price: price ?? this.price,
    vipPrice: vipPrice ?? this.vipPrice,
    rating: rating ?? this.rating,
    readNum: readNum ?? this.readNum,
    content: content ?? this.content,
    isFree: isFree ?? this.isFree,
    authors: authors ?? this.authors,
    onsaleTime: onsaleTime ?? this.onsaleTime,
    categoryId: categoryId ?? this.categoryId,
    pressId: pressId ?? this.pressId,
    producersId: producersId ?? this.producersId,
    isHave: isHave ?? this.isHave,
    isCollection: isCollection ?? this.isCollection,
    ratingCount: ratingCount ?? this.ratingCount,
    ratingList: ratingList ?? this.ratingList,
    categoryName: categoryName ?? this.categoryName,
    pressName: pressName ?? this.pressName,
    producersName: producersName ?? this.producersName,
    chapterId: chapterId ?? this.chapterId,
    chapterName: chapterName ?? this.chapterName,
    readChapterId: readChapterId?? this.readChapterId,
  );
  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['book_id'] = bookId;
    map['book_name'] = bookName;
    map['img'] = img;
    map['price'] = price;
    map['vip_price'] = vipPrice;
    map['rating'] = rating;
    map['read_num'] = readNum;
    map['content'] = content;
    map['is_free'] = isFree;
    map['authors'] = authors;
    map['onsale_time'] = onsaleTime;
    map['category_id'] = categoryId;
    map['press_id'] = pressId;
    map['producers_id'] = producersId;
    map['is_have'] = isHave;
    map['is_collection'] = isCollection;
    map['rating_count'] = ratingCount;
    map['rating_list'] = ratingList;
    map['category_name'] = categoryName;
    map['press_name'] = pressName;
    map['producers_name'] = producersName;
    map['chapter_id'] = chapterId;
    map['chapter_name'] = chapterName;
    map['read_chapter_id'] = readChapterId;
    return map;
  }



}

/// 删选模型
class FilterModel {
  FilterModel({
    this.id,
    this.name,
    this.selected = false
  });

  String? id;
  String? name;
  late bool selected = false;

}

/// 学习报告模型
class ReportModel {
  ReportModel({
    this.bookName,
    this.authors,
    this.img,
    this.progress,
    this.readSecond,
    this.maxSecond,
    this.lastChapter,
    this.commentPostNums,
    this.commentReplyNums,
    this.lineNums,
    this.colorNums,
    this.noteNums,
    this.questionAllNums,
    this.questionAccuracy,});

  ReportModel.fromJson(dynamic json) {
    bookName = json['book_name'];
    authors = json['authors'];
    img = json['img'];
    progress = json['progress'];
    readSecond = json['read_second'];
    maxSecond = json['max_second'];
    lastChapter = json['last_chapter'];
    commentPostNums = json['comment_post_nums'];
    commentReplyNums = json['comment_reply_nums'];
    lineNums = json['line_nums'];
    colorNums = json['color_nums'];
    noteNums = json['note_nums'];
    questionAllNums = json['question_all_nums'];
    questionAccuracy = json['question_accuracy'];
  }
  String? bookName;
  String? authors;
  String? img;
  String? progress;
  String? readSecond;
  num? maxSecond;
  String? lastChapter;
  num? commentPostNums;
  num? commentReplyNums;
  num? lineNums;
  num? colorNums;
  num? noteNums;
  num? questionAllNums;
  String? questionAccuracy;
  ReportModel copyWith({  String? bookName,
    String? authors,
    String? img,
    String? progress,
    String? readSecond,
    num? maxSecond,
    String? lastChapter,
    num? commentPostNums,
    num? commentReplyNums,
    num? lineNums,
    num? colorNums,
    num? noteNums,
    num? questionAllNums,
    String? questionAccuracy,
  }) => ReportModel(  bookName: bookName ?? this.bookName,
    authors: authors ?? this.authors,
    img: img ?? this.img,
    progress: progress ?? this.progress,
    readSecond: readSecond ?? this.readSecond,
    maxSecond: maxSecond ?? this.maxSecond,
    lastChapter: lastChapter ?? this.lastChapter,
    commentPostNums: commentPostNums ?? this.commentPostNums,
    commentReplyNums: commentReplyNums ?? this.commentReplyNums,
    lineNums: lineNums ?? this.lineNums,
    colorNums: colorNums ?? this.colorNums,
    noteNums: noteNums ?? this.noteNums,
    questionAllNums: questionAllNums ?? this.questionAllNums,
    questionAccuracy: questionAccuracy ?? this.questionAccuracy,
  );
  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['book_name'] = bookName;
    map['authors'] = authors;
    map['img'] = img;
    map['progress'] = progress;
    map['read_second'] = readSecond;
    map['max_second'] = maxSecond;
    map['last_chapter'] = lastChapter;
    map['comment_post_nums'] = commentPostNums;
    map['comment_reply_nums'] = commentReplyNums;
    map['line_nums'] = lineNums;
    map['color_nums'] = colorNums;
    map['note_nums'] = noteNums;
    map['question_all_nums'] = questionAllNums;
    map['question_accuracy'] = questionAccuracy;
    return map;
  }

}


class BookDownloadModel {
  BookDownloadModel({
    this.bookIv,
    this.download,});

  BookDownloadModel.fromJson(dynamic json) {
    bookIv = json['book_iv'];
    download = json['download'];
  }
  String? bookIv;
  String? download;
  BookDownloadModel copyWith({  String? bookIv,
    String? download,
  }) => BookDownloadModel(  bookIv: bookIv ?? this.bookIv,
    download: download ?? this.download,
  );
  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['book_iv'] = bookIv;
    map['download'] = download;
    return map;
  }

}


