part of user_notes_des;

class BuildLine extends StatelessWidget {
  final NoteModel model;
  const BuildLine({
    Key? key,
    required this.model
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      margin:  EdgeInsets.only(left: 10.w,right: 10.w,top: 10.w),
      padding:  EdgeInsets.all(10.w),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(4.w),
        color: Colors.white,
        boxShadow: [
          BoxShadow(
            color: const Color(0xFFC7C7C7).withOpacity(0.5),
            offset:  Offset(1.5.w, 0),
            blurRadius: 7.w,
            spreadRadius: 0.w,
          ),
        ],
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text(model.content??'',style: TextStyle(
            fontSize: 14.w,
            height: 1.5,
            color: Colours.c3,
            decoration: TextDecoration.underline,
            // decorationColor: Colors.red,
            decorationColor:Color(int.parse(model.color!.substring(1), radix: 16) + 0xFF000000),
            decorationThickness: 2
          ),),
          Gaps.vGaps8,
          Container(
            width: double.infinity,
            padding: EdgeInsets.symmetric(vertical: 5.w,horizontal: 10.w),
            color: Colours.cF8,
            child: Text(model.chapterName??'',style: TextStyle(fontSize: 12.w,height: 1.5,color: Colours.c9),),
          )
        ],
      ),
    );
  }
}
