part of image_view;

class ImageViewPage extends StatefulWidget {
  final List<String>images;
  final int currentIndex;
  const ImageViewPage({
    Key? key,
    required this.images,
    required this.currentIndex
  }) : super(key: key);

  @override
  State<ImageViewPage> createState() => _ImageViewPageState();
}

class _ImageViewPageState extends State<ImageViewPage> {

  final List<int> _cachedIndexes = <int>[];

  void _preloadImage(int index) {
    if (_cachedIndexes.contains(index)) {
      return;
    }
    if (0 <= index && index < widget.images.length) {
      final String url = widget.images[index];

      precacheImage(ExtendedNetworkImageProvider(url, cache: true), context);

      _cachedIndexes.add(index);
    }
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      extendBody: true,
      body: Container(
        color: Colors.black,
        child: ExtendedImageGesturePageView.builder(
          controller: ExtendedPageController(
            initialPage: widget.currentIndex,
            pageSpacing: 50,
          ),
          onPageChanged: (int page) {
            _preloadImage(page - 1);
            _preloadImage(page + 1);
          },
          itemCount: widget.images.length,
          itemBuilder: (BuildContext context, int index) {
            Console.log('-index---------------------------$index----');
            return GestureDetector(
              onTap: (){
                context.pop();
              },
              child: ExtendedImage.network(
                widget.images[index],
                fit: BoxFit.contain,
                mode: ExtendedImageMode.gesture,
                initGestureConfigHandler: (ExtendedImageState state) {
                  return GestureConfig(
                    //you must set inPageView true if you want to use ExtendedImageGesturePageView
                    inPageView: true,
                    initialScale: 1.0,
                    maxScale: 5.0,
                    animationMaxScale: 6.0,
                    initialAlignment: InitialAlignment.center,
                  );
                },
              ),
            );
          },
        ),
      ),
    );
  }
}
