part of widgets;

class CustomInputSearch extends StatelessWidget {
  final IconData iconData;
  final String? hintText;
  final TextEditingController? controller;
  final bool readOnly;
  final void Function()? onTap;

  const CustomInputSearch({
    Key? key,
    this.iconData = Icons.search_rounded,
    this.hintText,
    this.controller,
    this.readOnly = false,
    this.onTap,
  }) : super(key: key);

  EdgeInsetsGeometry get _padding {
    return EdgeInsets.symmetric(
      vertical: 7.w,
      horizontal: 20.w,
    );
  }

  @override
  Widget build(BuildContext context) {
    final inputDecoration = Theme.of(context).inputDecorationTheme;
    return TextField(
      readOnly: readOnly,
      controller: controller,
      onTap: onTap,
      style: TextStyle(
        // fontFamily: 'Sans',
        fontSize: 16.w,
        height: 1.2,
      ),
      decoration: InputDecoration(
        fillColor: Theme.of(context).colorScheme.tertiary,
        contentPadding: _padding.subtract(EdgeInsets.symmetric(
          horizontal: _padding.horizontal / 4,
        )),
        prefixIcon: Padding(
          padding: EdgeInsets.symmetric(
            horizontal: _padding.horizontal / 4,
          ),
          child: Icon(
            iconData,
            size: 24.w,
            color: const Color(0xFF858C94),
          ),
        ),
        hintStyle:  TextStyle(
            color: Colours.c9,
            fontSize: 12.w,
            height: 1.5,
        ),
        prefixIconConstraints: const BoxConstraints(),
        hintText: hintText ?? '搜索',
        enabledBorder: inputDecoration.enabledBorder?.copyWith(
          borderSide: const BorderSide(color: Colors.transparent),
        ),
        focusedBorder: inputDecoration.enabledBorder?.copyWith(
          borderSide: const BorderSide(color: Colors.transparent),
        ),
        disabledBorder: inputDecoration.enabledBorder?.copyWith(
          borderSide: const BorderSide(color: Colors.transparent),
        ),
      ),
    );
  }
}


