part of library;

class LibraryController extends GetxController with GetTickerProviderStateMixin{

  final EasyRefreshController refreshController = EasyRefreshController(
    controlFinishLoad: true,
    controlFinishRefresh: true,
  );
  
  // 分类数据
  List<CategoryModel> categories = [];
  // 标签数据
  List<LabelModel> labels = [];
  // 图书列表数据
  List<CourseModel> books = [];
  // 广告数组
  List<AdModel> ads = [];

  late LabelModel selectedLabel = LabelModel();

  late TabController tabController = TabController(length:categories.length, vsync: this);

  final int _limit = 20;
  int _page = 1;
  bool _noMore = false;

  @override
  void onInit() {
    // 获取分类数据
    _getTabs();
    super.onInit();

  }

  @override
  void onReady() {
    // 获取标签数据
    _getLabels();
    _getAds();
    onRefresh();
    super.onReady();
  }

  @override
  void onClose() {
    tabController.dispose();
    refreshController.dispose();
    super.onClose();
  }
  /// 收藏 与 取消收藏
  void love({
    required String bookId,
    required num isCollection
  }) async {
    if (isCollection == 0){
      isCollection = 1;
    }
    else{
      isCollection = 0;
    }
    bool result = await CommonAPI.love(bookId: bookId, love: isCollection.toString());
    if (result) {
      onRefresh();
    }
  }
  //

  void selectLabel(LabelModel model){
    for (LabelModel m in labels){
      m.selected = false;
    }
    model.selected = true;
    selectedLabel = model;
    update();
  }

  /// 获取广告数据
  void _getAds() async {
    ads = await CommonAPI.list(type: '1');
    update();
  }

  /// 获取tab分类数据
  void _getTabs() async {
    categories = await LibraryAPI.categories();
    tabController.dispose();
    tabController = TabController(length:categories.length, vsync: this);
    update();
  }

  /// 获取标签数据
  void _getLabels() async {
    labels = await LibraryAPI.labels();
    selectedLabel = labels.first;
    selectedLabel.selected = true;
    update();
  }


  /// 获取图书列表数据
  Future<void> _getBooks([bool isRefresh = false]) async {
    if (isRefresh) _page = 1;
    // 网路请求
    final result = await LibraryAPI.books(
        page: _page,
        limit: _limit
    );
    // 如果是刷新 清理数据
    if (isRefresh) books.clear();
    books.addAll(result);
    _page ++;
    _noMore = result.length < _limit;
    update();

  }

  void onRefresh() async {
    try {
      await _getBooks(true);
      refreshController.finishRefresh(IndicatorResult.success);
      refreshController.resetFooter();
    } catch (error) {
      refreshController.finishRefresh(IndicatorResult.fail);
    }
  }

  void onLoading() async {
    if (_noMore) {
      refreshController.finishLoad(IndicatorResult.noMore);
      return;
    }
    try {
      await _getBooks();
      refreshController.finishLoad();
    } catch (error) {
      refreshController.finishLoad(IndicatorResult.fail);
    }
  }





}