part of routes;

abstract class Routes {
  static final RouteObserver<Route> observer = RouteObservers();
  static List<String> history = [];

  static const splash = 'splash';
  static const main = 'main';
  static const ad = 'ad';

  static const web = 'web';

  // 支付界面
  static const bookPay = 'book_pay';
  // 用户协议 和 隐私政策
  static const terms = 'terms';
  // 搜索
  static const search = 'search';


  /// 登录模块
  // 登录
  static const login = 'login';
  // 忘记密码
  static const forgetPwd = 'forget_pwd';
  // 重置密码
  static const resetPwd = 'reset_pwd';


  /// 课程模块
  // 详情
  static const bookDetail = 'book_detail';
  // 评分及书评
  static const bookScore = 'book_score';
  // 学习报告
  static const studyReport = 'study_report';


  /// 图书馆模块


  /// 书架模块
  static const creditPoints = 'credit_points';
  static const shop = 'shop';



  /// 我的模块
  // 个人信息
  static const userInfo = 'user_info';
  // 修改昵称
  static const nike = 'nike';
  // 性别
  static const gender = 'gender';
  // 设置
  static const set = 'set';
  // 版本
  static const version = 'version';
  // 版本介绍
  static const versionDes = 'version_des';
  // 我的收藏
  static const collect = 'collect';
  // 紫金币记录
  static const coin = 'coin';
  // 积分记录
  static const point = 'point';
  // 消息
  static const msgs = 'msgs';
  // 关于
  static const about = 'user_about';
  // 最近学习
  static const studyHistory = 'study_history';
  // 我的收藏
  static const love = 'love';
  // 笔记
  static const note = 'note';
  // 错题
  static const wrong = 'wrong';
  // 讨论
  static const discuss = 'discuss';
  // 优惠券
  static const coupon = 'coupon';
  // 账号安全
  static const security = 'security';
  // 修改手机号
  static const changePhone = 'change_change';
  // 修改密码
  static const changePwd = 'change_pwd';
  // 意见反馈
  static const feedback = 'feedback';




  static final GoRouter config = GoRouter(
      // initialLocation: '/$splash',
      initialLocation: '/',
      observers: [observer],
      // redirect: _RouteRedirect.auth,
      routes: [
        GoRoute(
            path: '/$splash',
            name: splash,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const SplashPage(),
            ),
        ),
        GoRoute(
            path: '/',
            name: main,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const MainPage()
            )
        ),
        GoRoute(
            path: '/$ad',
            name: ad,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const AdPage()
            )
        ),
        /// 登录模块
        GoRoute(
            path: '/$login',
            name: login,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const LoginPage()
            )
        ),
        GoRoute(
            path: '/$forgetPwd',
            name: forgetPwd,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const ForgetPwdPage()
            )
        ),
        GoRoute(
            path: '/$resetPwd',
            name: resetPwd,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: ResetPwdPage(
                  phone: state.uri.queryParameters['phone'].toString(),
                  code: state.uri.queryParameters['code'].toString(),
                )
            )
        ),
        GoRoute(
            path: '/$web',
            name: web,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const WebPage()
            )
        ),
        GoRoute(
            path: '/$about',
            name: about,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const AboutPage()
            )
        ),
        GoRoute(
            path: '/$bookPay',
            name: bookPay,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: BookPayPage(buy: state.extra as List<CourseModel>,)
            )
        ),
        GoRoute(
            path: '/$terms',
            name: terms,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const TermsPage()
            )
        ),
        GoRoute(
            path: '/$msgs',
            name: msgs,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const MsgPage()
            )
        ),
        GoRoute(
            path: '/$userInfo',
            name: userInfo,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const UserInfoPage()
            )
        ),
        GoRoute(
            path: '/$nike',
            name: nike,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const UserNickPage()
            )
        ),
        GoRoute(
            path: '/$coin',
            name: coin,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const UserCoinPage()
            )
        ),
        GoRoute(
            path: '/$bookDetail',
            name: bookDetail,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: BookDetailPage(
                  bookId: state.uri.queryParameters['book_id'].toString(),
                )
            )
        ),
        GoRoute(
            path: '/$bookScore',
            name: bookScore,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: BookScorePage(
                  bookId: state.uri.queryParameters['book_id'].toString(),
                )
            )
        ),
        GoRoute(
            path: '/$studyReport',
            name: studyReport,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const StudyReportPage()
            )
        ),
        GoRoute(
            path: '/$creditPoints',
            name: creditPoints,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const CreditPointsPage()
            )
        ),
        GoRoute(
            path: '/$search',
            name: search,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const SearchPage()
            )
        ),
        GoRoute(
            path: '/$studyHistory',
            name: studyHistory,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const StudyHistoryPage()
            )
        ),
        GoRoute(
            path: '/$love',
            name: love,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const UserLovePage()
            )
        ),
        GoRoute(
            path: '/$shop',
            name: shop,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const BookShopPage()
            )
        ),
        GoRoute(
            path: '/$note',
            name: note,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const UserNotePage()
            )
        ),
        GoRoute(
            path: '/$wrong',
            name: wrong,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const UserWrongPage()
            )
        ),
        GoRoute(
            path: '/$point',
            name: point,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const UserPointPage()
            )
        ),
        GoRoute(
            path: '/$discuss',
            name: discuss,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const UserDiscussPage()
            )
        ),
        GoRoute(
            path: '/$coupon',
            name: coupon,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const UserCouponPage()
            )
        ),
        GoRoute(
            path: '/$set',
            name: set,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const UserSetPage()
            )
        ),
        GoRoute(
            path: '/$version',
            name: version,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const VersionPage()
            )
        ),
        GoRoute(
            path: '/$versionDes',
            name: versionDes,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: VersionDesPage(model: state.extra as VersionModel,)
            )
        ),
        GoRoute(
            path: '/$security',
            name: security,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: UserSecurityPage(model: state.extra as UserInfoModel,)
            )
        ),
        GoRoute(
            path: '/$changePhone',
            name: changePhone,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const ChangePhonePage()
            )
        ),
        GoRoute(
            path: '/$changePwd',
            name: changePwd,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: ChangePwdPage(type:state.uri.queryParameters['type'].toString())
            )
        ),
        GoRoute(
            path: '/$feedback',
            name: feedback,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const UserFeedbackPage()
            )
        ),

      ]
  );

}

abstract class _RouteRedirect {
  static String? auth(BuildContext context, GoRouterState state) {
    if (UserStore.to.isLogin) return null;
    return '/${Routes.login}';
  }
}