import 'package:flutter/cupertino.dart';
import 'package:flutter/services.dart';
import 'package:flutter_book/services/index.dart';
import 'package:flutter_book/store/index.dart';
import 'package:flutter_book/utils/index.dart';
import 'package:flutter_inappwebview/flutter_inappwebview.dart';
import 'package:get/get.dart';
class Global {
  static Future<void> init() async {
    // 确保 Flutter 绑定已经初始化
    WidgetsFlutterBinding.ensureInitialized();
    // 设置应用程序的首选屏幕方向
    await SystemChrome.setPreferredOrientations([DeviceOrientation.portraitUp]);
    // String documentRoot = await Tools.getDirectory();
    // final InAppLocalhostServer localhostServer =
    // InAppLocalhostServer(documentRoot: '$documentRoot/',shared: true);
    // await localhostServer.start();
    // print('本地服务器已成功启动，根目录为: $documentRoot');
    SqlManager.init();

    // WidgetsBinding.instance?.addObserver(AppLifecycleObserver());

    await Future.wait([
      // 配置存储
      Get.putAsync<StorageService>(() => StorageService().init()),
    ]).whenComplete(() {

      print('初始化****************');
      // 网络
      Get.put<HttpService>(HttpService());
      //配置基本设置
      Get.put<ConfigStore>(ConfigStore());
      //
      Get.put<UserStore>(UserStore());

    });
  }
}
class AppLifecycleObserver extends WidgetsBindingObserver {
  @override
  void didChangeAppLifecycleState(AppLifecycleState state) {
    if (state == AppLifecycleState.paused || state == AppLifecycleState.detached) {
      SqlManager.closeDatabase(); // 应用进入后台时关闭数据库连接
    }
  }
}