part of user_discuss_des;

class UserDiscussDesPage extends StatefulWidget {
  final CourseModel model;
  const UserDiscussDesPage({
    Key? key,
    required this.model
  }) : super(key: key);

  @override
  State<UserDiscussDesPage> createState() => _UserDiscussDesPageState();
}

class _UserDiscussDesPageState extends State<UserDiscussDesPage> {

  List<Tab> tabs = [
    const Tab(text: '全部',),
    const Tab(text: '发起',),
    const Tab(text: '参与',),
  ];

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        appBar: AppBar(
          centerTitle: true,
          title: const Text('讨论详情'),
        ),
        body: DefaultTabController(
            length: tabs.length,
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                BuildItem(model: widget.model),
                Expanded(child: Container(
                  decoration: BoxDecoration(
                    color: Colors.white,
                    boxShadow: [
                      BoxShadow(
                        color: const Color(0xFFC7C7C7).withOpacity(0.5),
                        offset: Offset(1.5.w, 0),
                        blurRadius: 7.w,
                        spreadRadius: 0.w,
                      ),
                    ],
                  ),
                  child: Column(children: [
                    ClipRRect(
                      borderRadius:BorderRadius.only(topLeft: Radius.circular(5.w),topRight: Radius.circular(5)),
                      child: Container(
                        width: double.infinity,
                        color: Colors.white,
                        height: 35.w,
                        child: TabBar(
                            indicator: UnderlineTabIndicator(
                              borderRadius: BorderRadius.circular(0.75.w),
                              borderSide: BorderSide(width: 1.5.w,color: AppTheme.primary),
                              insets: EdgeInsets.symmetric(horizontal: 22.w), // 设置标签下面指示器的水平内边距
                            ),
                            labelPadding: EdgeInsets.symmetric(horizontal: 20.w),
                            indicatorSize: TabBarIndicatorSize.label,
                            indicatorColor: AppTheme.primary,
                            indicatorWeight: 1.5,
                            labelStyle: TextStyle(color: AppTheme.primary,fontSize: 15.w,height: 1.5,fontWeight: Fonts.medium),
                            unselectedLabelColor: Colours.c9,
                            unselectedLabelStyle: TextStyle(color: Colours.c9,fontSize: 15.w,height: 1.5),
                            isScrollable: true,
                            tabs: tabs
                        ),
                      ),
                    ),
                    Container(
                      height: 0.5.w,
                      color: Colours.cF2,
                    ),
                    // SizedBox(height:10.w),
                    Expanded(
                      child: TabBarView(
                          children: List.generate(tabs.length, (index){
                            return BuildListPage(tag:'$index',model:widget.model);
                          })
                      ),
                    )
                  ],),
                )),
                
              ],
            )
        ),
      );
  }
}
