part of order_evaluate;



class OrderEvaluatePage extends StatefulWidget {
  const OrderEvaluatePage({Key? key}) : super(key: key);

  @override
  State<OrderEvaluatePage> createState() => _OrderEvaluatePageState();
}

class _OrderEvaluatePageState extends State<OrderEvaluatePage> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        centerTitle: true,
        title: const Text('订单评价'),
      ),
      body: Column(
        children: [
          Container(
            margin: const EdgeInsets.all(10),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(8),
              color: const Color(0xFFF9F9F9),
              boxShadow: [
                BoxShadow(
                  color: const Color(0xFFC7C7C7).withOpacity(0.5),
                  offset: const Offset(3, 0),
                  blurRadius: 7.w,
                  spreadRadius: 0.w,
                ),
              ],
            ),
            child: ClipRRect(
              borderRadius: BorderRadius.circular(8),
              child: Column(
                mainAxisSize: MainAxisSize.min,
                children: [
                  // 图书容器
                  Container(
                    color: Colours.cF8,
                    padding: EdgeInsets.symmetric(horizontal: 11,vertical: 12),
                    child: Row(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Container(
                          width: 71,
                          height: 86,
                          color: Colors.cyan,
                        ),
                        Gaps.hGaps10,
                        Text('一想到还有95%的问题留给人类，我就放',style: TextStyle(fontSize: 13,height: 1.5,fontWeight: Fonts.medium,color: Colours.c3),maxLines: 2,overflow: TextOverflow.ellipsis,)

                      ],
                    ),
                  ),
                  // 评价容器
                  Container(
                    padding: const EdgeInsets.symmetric(vertical: 15),
                    width: double.infinity,
                    height: 160,
                    color: Colors.white,
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Row(
                          crossAxisAlignment: CrossAxisAlignment.center,
                          children: [
                            Container(
                                padding: const EdgeInsets.only(left: 10),
                                child: const Text('评分'),
                            ),
                            Gaps.hGaps20,
                            AbsorbPointer(
                              absorbing: false,
                              child: CustomRating(
                                max: 5,
                                score:0 ,
                                star: const Star(
                                  fat: 0.5,
                                  progress: 7,
                                  fillColor: AppTheme.primary,
                                  size: 16,
                                  emptyColor: Colours.cE2,
                                ), onRating: (double ) {},
                              ),
                            ),
                          ],
                        ),
                        Container(
                          // color: Colors.red,
                          child:  const CustomInput(
                            decoration:  InputDecoration(
                                focusedBorder: InputBorder.none,
                                border: InputBorder.none,
                                enabledBorder: InputBorder.none,
                                errorBorder: InputBorder.none,
                                fillColor:Colors.white,
                                hintStyle: TextStyle(fontSize: 14,height: 1.5,color: Colours.c6)
                            ),
                            maxLines: 5,
                            hintText: '请简要描述',
                          ),
                        ),

                      ],
                    ),
                  ),

                ],
              ),
            ),
          ),
          const SizedBox(height: 50,),
          Container(
            margin: const EdgeInsets.symmetric(horizontal: 10),
            child: CustomGradientButton(
              text: '提交评价',
              isEnabled: false,
              onPressed: () {
                print('11111111111111111');
              },
            ),
          )
        ],
      ),
    );
  }
}
