part of user_discuss_des;

class BuildDiscuss extends StatelessWidget {
  final DiscussModel model;
  const BuildDiscuss({
    Key? key,
    required this.model
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.only(left: 10,right: 10,top: 10),
      padding: const EdgeInsets.all(10),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(4),
        color: Colors.white,
        boxShadow: [
          BoxShadow(
            color: const Color(0xFFC7C7C7).withOpacity(0.5),
            offset: const Offset(1.5, 0),
            blurRadius: 7.w,
            spreadRadius: 0.w,
          ),
        ],
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          RichText(text: TextSpan(
            children: [
              const TextSpan(text: '话题：',style: TextStyle(
                  fontSize: 14,
                  height: 1.5,
                  color: Colours.c3,
              )),
              TextSpan(text: model.title,style: const TextStyle(
                  fontSize: 14,
                  height: 1.5,
                  color: Colours.c3,
                  fontWeight: Fonts.medium
              )),
            ]
          )),
          Gaps.vGaps10,
          Container(
            height: 0.5,
            color: Colours.cF2,
          ),
          _buildItem(model),
          Container(
            margin:const EdgeInsets.only(left: 15),
              child: _buildListView(model.commentAll != null ? model.commentAll!:[])
          ),
          Gaps.vGaps13,
          Container(
            width: double.infinity,
            padding: const EdgeInsets.symmetric(vertical: 5,horizontal: 10),
            color: Colours.cF8,
            child:Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Text(model.chapterName??'',style: const TextStyle(fontSize: 12,height: 1.5,color: Colours.c9),),
                Text('内容：${model.quoteContent??''}',style: const TextStyle(fontSize: 12,height: 1.5,color: Colours.c9),),
              ],
            )
          )
        ],
      ),
    );
  }


  Widget _buildItem(DiscussModel model,{int type =0}){
    return Row(
      children: [
        ClipRRect(
          borderRadius: BorderRadius.circular(17.5),
          child: Container(
            width: 35,
            height: 35,
            color: Colors.red,
            child: CustomImage.network(url: model.personPic??''),
          ),
        ),
        Expanded(
          child: Container(
            margin: const EdgeInsets.only(left: 10,top: 10),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    Row(
                      children: [
                        Text(model.personName??'',style: const TextStyle(fontSize: 12,height: 1.5,color: Colours.c9),),
                        Gaps.hGaps10,
                        type ==0?const SizedBox():const Text('发起人',style: TextStyle(fontSize: 11,height: 1.5,color: AppTheme.primary),)
                      ],
                    ),
                    Text(model.createTime??'',style: const TextStyle(fontSize: 12,height: 1.5,color: Colours.c9),)
                  ],
                ),
                Text(model.content??'',style: const TextStyle(fontSize: 13,height: 1.5,color: Colours.c3),),
                Row(
                  children: [
                    Row(
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: [
                        SizedBox(
                          height: 15,
                          width: 15,
                          // color: Colors.green,
                          child: Image.asset('assets/images/love.png'),
                        ),
                        Text(model.goodNum.toString(),style: const TextStyle(fontSize:12,height: 1.5,color: Colours.c9))
                      ],
                    ),
                    Gaps.hGaps15,
                    Row(
                      children: [
                        SizedBox(
                          height: 15,
                          width: 15,
                          // color: Colors.yellow,
                          child: Image.asset('assets/images/discuss_big.png'),
                        ),
                        Text(model.replyNum.toString(),style: const TextStyle(fontSize:12,height: 1.5,color: Colours.c9))
                      ],
                    )
                  ],
                )
              ],
            ),
          ),
        )
      ],
    );
  }

  Widget _buildListView(List<DiscussModel> data){
    return ListView.builder(
      physics: const NeverScrollableScrollPhysics(),
      shrinkWrap: true,
      itemBuilder: (BuildContext context,int index){
        return _buildItem(data[index]);
      },
      itemCount: data.length,
    );
  }
}


