part of user_msg;

class MsgPage extends StatelessWidget {
  const MsgPage({Key? key}) : super(key: key);



  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        context.pop(true);
        return false;
      },
      child: GetBuilder<MsgController>(
        init: MsgController(),
        builder:(controller) => Scaffold(
          appBar: AppBar(
            title: const Text('消息中心'),
            centerTitle: true,
          ),
          body: Container(
            color: Colours.cF9,
            child: CustomPullScrollView(
              controller: controller.refreshController,
              onRefresh: controller.onRefresh,
              onLoading: controller.onLoading,
              child: ListView.builder(
                  itemBuilder: (BuildContext context, int index){
                    return GestureDetector(
                      child: BuildItem(model: controller.msgs[index],),
                      onTap: () async{
                          controller.read(controller.msgs[index].id.toString());
                           final result = await context.pushNamed(Routes.coin);
                           if (result == true){
                             controller.onRefresh();
                           }
                      },
                    );
                  },
                  itemCount: controller.msgs.length,
              ),
            ),
          ),
        ),
      ),
    );
  }
}
