part of user_notes_des;

class BuildListPage extends StatefulWidget {
  final String tag;
  final CourseModel model;
  const BuildListPage({
    Key? key,
    required this.tag,
    required this.model
  }) : super(key: key);


  @override
  State<BuildListPage> createState() => _BuildListPageState();
}

class _BuildListPageState extends State<BuildListPage> with AutomaticKeepAliveClientMixin{
  @override
  Widget build(BuildContext context) {
    return GetBuilder<UserNotesDesController>(
      tag: widget.tag,
      init: UserNotesDesController(widget.tag,widget.model),
      builder: (controller) =>CustomPullScrollView(
        controller: controller.refreshController,
        onLoading: controller.onLoading,
        child: ListView.builder(
            itemBuilder: (BuildContext context,int index){
              NoteModel model = controller.notes[index];
              // 划线
              if(model.types == 1){
                return  BuildLine(model: model,);
              }
              // 高亮
              else if(model.types == 2){
                return BuildHigh(model: model,);
              }
              // 笔记
              else if(model.types == 3){
                return BuildNote(model: model,);
              }
            },
          itemCount: controller.notes.length,
        ),
      ),
    );
  }

  @override
  bool get wantKeepAlive => true;
}
