part of user_feedback;

class UserFeedbackPage extends StatefulWidget {
  const UserFeedbackPage({Key? key}) : super(key: key);

  @override
  State<UserFeedbackPage> createState() => _UserFeedbackPageState();
}

class _UserFeedbackPageState extends State<UserFeedbackPage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<UserFeedbackController>(
        init: UserFeedbackController(),
        builder: (controller) => Scaffold(
            appBar: AppBar(
              title: const Text('意见反馈'),
              centerTitle: true,
            ),
            body: Container(
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(8.w),
                color: Colors.transparent,
              ),
              child: Column(
                mainAxisSize: MainAxisSize.min,
                children: [
                  Container(
                    alignment: Alignment.centerLeft,
                    padding: EdgeInsets.only(left: 10.w, top: 16.5.w),
                    child: Text.rich(TextSpan(children: [
                      const TextSpan(
                          text: "*",
                          style:
                              TextStyle(fontSize: 14, color: Colours.cAB1941)),
                      TextSpan(
                          text: "问题描述或建议",
                          style: TextStyle(
                              fontSize: 14.w,
                              color: Colours.c3,
                              fontWeight: FontWeight.bold)),
                    ])),
                  ),
                  Container(
                    padding: EdgeInsets.only(
                        left: 10.w, right: 10.w, top: 6.5.w, bottom: 10.w),
                    child: CustomInput(
                      controller: controller.searchController,
                      maxLines: 5,
                      hintText: '请描述你的问题，我们会尽快处理并回复',
                      onChanged: (text){
                        controller.setCanClick();
                      },
                    ),
                  ),

                  // _buildTextField(context),
                  Container(
                      padding: EdgeInsets.only(
                          left: 10.w, right: 10.w, top: 35.w, bottom: 20.w),
                      width: double.infinity,
                      child: CustomGradientButton(
                        text: '提交反馈',
                        isEnabled: controller.enable,
                        onPressed: () {
                          controller.upFeedback();
                          FocusNode blankNode = FocusNode();
                          FocusScope.of(context).requestFocus(blankNode);
                          // controller.onLogin(context);
                        },
                      )),
                ],
              ),
            )));
  }
}
