part of answer;


class AnswerPage extends StatefulWidget {
  final Map<String,String> params;
  const AnswerPage({
    Key? key,
    required this.params
  }) : super(key: key);

  @override
  State<AnswerPage> createState() => _AnswerPageState();
}

class _AnswerPageState extends State<AnswerPage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder(
      init: AnswerController(widget.params),
      builder: (aController) =>Scaffold(
          appBar: AppBar(
            title: Text('${aController.params['title']}'),
          ),
          body: InAppWebView(
            initialUrlRequest: URLRequest(
              // url: Uri.parse(widget.params['url']??''),
                url: WebUri.uri(Uri.parse(aController.params['url']??''))
            ),
            onLoadStop: (controller, url) {
              String str = '$kServerUrl,${aController.params['book_id']},${aController.params['chapter_id']},${aController.params['token']},${aController.params['position']}';
              Console.log('知识测评--------传给前端的参数--------------------------------$str');
              controller.evaluateJavascript(source: 'callbackInFlutterComponent("$str");');

              controller.addJavaScriptHandler(handlerName: 'evaluatingSubmitCallback', callback: (args){
                Console.log('知识测评----提交按钮回调------------------------------------------------$args');
                context.pop();
                // readController.titleInput.text = args.toString();
              });
              controller.addJavaScriptHandler(handlerName: 'showLoadingCallback', callback: (args) async {
                CustomToast.loading();
              });
              controller.addJavaScriptHandler(handlerName: 'dismissLoadingCallback', callback: (args) async {
                CustomToast.dismiss();
              });
              // 答完题展示答题结果页
              controller.addJavaScriptHandler(handlerName: 'submitSuccessCallback', callback: (args) async {
                aController.changeToResult();
              });
            },
            onConsoleMessage: (controller, consoleMessage) {
              // 接收从 WebView 发送的消息
              Console.log("知识测评-------Received message from WebView-----------------------------: ${consoleMessage.message}");
            },
          )
      ),
    );
  }
}
