import 'dart:ui';

import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_book/routes/index.dart';
import 'package:flutter_book/store/index.dart';
import 'package:flutter_book/theme.dart';
import 'package:flutter_book/widgets/index.dart';
import 'package:flutter_bugly/flutter_bugly.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:get/get.dart';
import 'package:oktoast/oktoast.dart';
import 'package:flutter_localizations/flutter_localizations.dart';

import 'global.dart';

void main() {
  Global.init().then((_) {
    Future.wait([
      UserStore.to.profile(),
    ]).whenComplete(() {
      FlutterBugly.postCatchedException(() {
        // 如果需要 ensureInitialized，请在这里运行。
        WidgetsFlutterBinding.ensureInitialized();
        runApp(const MyApp());
        FlutterBugly.init(
          androidAppId: "8b4da96535",
          iOSAppId: "290703a371",
        );
      });
      // runApp(const MyApp());
      //FlutterNativeSplash.remove();
    });
  });
  SystemChrome.setSystemUIOverlayStyle(SystemUiOverlayStyle.light);
}

class MyApp extends StatelessWidget {
  const MyApp({Key? key}): super(key: key);

  // This widget is the root of your application.
  @override
  Widget build(BuildContext context) {
        return ScreenUtilInit(
        designSize: const Size(375, 667),
        builder: (context, child) => GetBuilder<ConfigStore>(
              builder: (config) => MaterialApp.router(
                debugShowCheckedModeBanner: false,
                title: '紫荆数智学堂',
                theme: AppTheme.light,
                darkTheme: AppTheme.dark,
                themeMode: ThemeMode.light,
                routerConfig: Routes.config,
                builder: CustomToast.init(
                  context: context,
                  builder: (context, child) {
                    return ScrollConfiguration(
                      behavior: _NoShadowScrollBehavior(),
                      child: OKToast(
                          radius: 8.0,
                          backgroundColor: const Color(0xFF000000).withOpacity(0.2),
                          textPadding: const EdgeInsets.symmetric(horizontal: 16.0, vertical: 10.0),
                          position: ToastPosition.bottom,
                          // textStyle: ,
                          child: child ?? const Material(),
                      ),
                    );
                  },
                ),
                supportedLocales: const [
                  Locale.fromSubtags(languageCode: 'zh'),
                ],
                localizationsDelegates: const [
                  GlobalMaterialLocalizations.delegate,
                  GlobalWidgetsLocalizations.delegate,
                  GlobalCupertinoLocalizations.delegate,
                  // S.delegate,
                ],
                locale: PlatformDispatcher.instance.locale,
                // supportedLocales: S.delegate.supportedLocales,
              ),
          ),
        );
  }
}


class _NoShadowScrollBehavior extends ScrollBehavior {
  @override
  Widget buildOverscrollIndicator(
      BuildContext context,
      Widget child,
      ScrollableDetails details,
      ) {
    switch (getPlatform(context)) {
      case TargetPlatform.iOS:
      case TargetPlatform.macOS:
        return child;
      case TargetPlatform.android:
        return GlowingOverscrollIndicator(
          showLeading: false,
          showTrailing: false,
          axisDirection: details.direction,
          color: Theme.of(context).colorScheme.primary,
          child: child,
        );
      case TargetPlatform.fuchsia:
      case TargetPlatform.linux:
      case TargetPlatform.windows:
        return GlowingOverscrollIndicator(
          showLeading: false,
          showTrailing: false,
          axisDirection: details.direction,
          color: Theme.of(context).colorScheme.primary,
          child: child,
        );
    }
  }
}


