part of read_info;


class ReadInfoPage extends StatefulWidget {
  final Map<String,String> params;
  const ReadInfoPage({
    Key? key,
    required this.params
  }) : super(key: key);

  @override
  State<ReadInfoPage> createState() => _ReadInfoPageState();
}

class _ReadInfoPageState extends State<ReadInfoPage> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
        appBar: AppBar(
          title: Text('${widget.params['title']}'),
        ),
        body: InAppWebView(
          initialUrlRequest: URLRequest(
              url: WebUri.uri(Uri.parse(kReadInfo))
          ),
          initialSettings:InAppWebViewSettings(
            // http的请求也不做限制
              mixedContentMode:MixedContentMode.MIXED_CONTENT_ALWAYS_ALLOW
          ),
          onLoadStop: (controller, url) {
            String jsonStr = jsonEncode(widget.params);
            controller.evaluateJavascript(source: 'callbackInFlutterComponent($jsonStr)');
            // 图片预览
            controller.addJavaScriptHandler(handlerName: 'scaleImageCallback', callback: (args){
              String url = args.first[0].toString();
              String title = args.first[1].toString();
              Map<String,String> params = {
                'url':url,
                'title':title,
              };
              Console.log('监听图片预览---------------给页面传参---------------------------------$params');
              context.pushNamed(Routes.scaleImage,queryParameters: params);
            });
            // 扩展阅读内的链接跳页
            controller.addJavaScriptHandler(handlerName: 'openLinkCallback', callback: (args){
              Console.log('监听外部链接------------------------------------------------$args');
              context.pushNamed(Routes.link,queryParameters: {'url': args.first.toString()});
            });
          },

          onConsoleMessage: (controller, consoleMessage) {
            // 接收从 WebView 发送的消息
            Console.log("画廊扩展阅读-------Received message from WebView-----------------------------: ${consoleMessage.message}");
          },
        )
    );
  }
}
