part of utils;


//'bucket_comment' => 'zxts-comment-file',       'bucket_user' => 'zxts-user-file',    'endpoint' => 'zijingebook.com',

class OssTool {
  late OssModel ossModel;
  final String bucketName;
  OssTool(this.bucketName){
    initOss(bucketName);
  }


  void initOss(String bucketName) async {
    Client.init(ossEndpoint: 'oss-cn-beijing.aliyuncs.com', bucketName:bucketName,authGetter: _authGetter);
  }

  // 获取临时凭证
  Future<Auth> _authGetter() async {
    final result = await CommonAPI.oss();
    return  Auth(
      accessKey: result.accessKeyId!,
      accessSecret: result.accessKeySecret!,
      expire: result.expiration!,
      secureToken: result.securityToken!,
    );
  }

  // 本地文件上传
  Future<Response<dynamic>> putObjectFile(String filePath) async {
    List<String> parts = filePath.split('/');
    String fileName = parts.last;
    final String path = '${DateTime.now().year}/${DateTime.now().month.toString().padLeft(2,'0')}/${DateTime.now().day.toString().padLeft(2,'0')}';
    final Response<dynamic> resp = await Client().putObjectFile(
      filePath,
      fileKey: '$path/$fileName'
    );
    return resp;
  }

  // 批量本地文件上传
  Future<List<Response>> putObjectFiles(List<String> filePaths){
    return Client().putObjectFiles(
      filePaths.map((e){
        return AssetFileEntity(
          filepath: e
        );
      }).toList()
    );
  }


}