part of help_cneter_content;

class HelpCenterContentController extends GetxController {
  final String id;
  HelpCenterContentModel helpCenterContentModel = HelpCenterContentModel();

  HelpCenterContentController(this.id);

  late InAppWebViewController webViewController;

  @override
  void onReady() {
    _getHelpCenterContent(id);
    super.onReady();
  }

  /// 获取帮助中心内容
  void _getHelpCenterContent(String id) async {
    helpCenterContentModel = await MineAPI.helpCenterContent(id);

    webViewController.loadData(data: """
                        <!DOCTYPE html>
                        <html lang="zh-CN">
                        <head>
                        <meta charset="utf-8" />
                        <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
                        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no" />
                        <meta http-equiv="Cache-Control" content="no-transform" />
                        <meta http-equiv="Cache-Control" content="no-siteapp" />
                        <style>
                            *{ margin: 0; padding: 5px;}
                            html{ font-size: 10px;}
                            body p{ font-size: 1.5rem; line-height:2.4rem;color: #999}
                            img,video,pre,code{ max-width:100%}
                            pre{white-space: pre-wrap;word-wrap: break-word;word-break: break-all}
                        </style>
                        </head>
                        <body>
                            ${helpCenterContentModel.helpContent??''}
                        </body>
                        </html>
                        """,);
    update();
  }
}
