part of apis;


abstract class LibraryAPI {

  /// 1、图书分类
  ///
  static Future <List<CategoryModel>> categories() async {
    final result = await HttpService.to.post(
      '/v1/book/category/getCategoryListAll',
      params: {},
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return CategoryModel.fromJson(result.data['list'][index]);
    });
  }

  /// 2、图书标签
  ///
  static Future <List<LabelModel>> labels() async {
    final result = await HttpService.to.post(
      '/v1/book/category/getLabelListAll',
      params: {},
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return LabelModel.fromJson(result.data['list'][index]);
    });
  }

  /// 3、书籍列表
  ///
  static Future <List<CourseModel>> books({
    int page = 1,
    int limit = 20,
  }) async {
    final result = await HttpService.to.post(
      '/v1/book/category/getBookList',
      params: {
        'page': page,
        'pageSize': limit,
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return CourseModel.fromJson(result.data['list'][index]);
    });
  }





}