part of apis;

abstract class CommonAPI {

  /// 1、广告位接口
  ///
  static Future <List<AdModel>> list({
    required String type,
  }) async {
    final result = await HttpService.to.post(
      '/v1/ad/ad/getListAll',
      params: {
        'type': type,
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return AdModel.fromJson(result.data['list'][index]);
    });
  }

  /// 2、消息接口
  ///
  static Future <List<MsgModel>> msgs({
    int page = 1,
    int limit = 10,
  }) async {
    final result = await HttpService.to.post(
      '/v1/message/Message/getList',
      params: {
        'currentPage': page,
        'pageSize': limit,
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return MsgModel.fromJson(result.data['list'][index]);
    });
  }

  /// 3、消息未读数
  ///
  static Future <int> num() async {
    final result = await HttpService.to.post(
      '/v1/message/Message/getMessageNums',
      params: {},
    );
    if (result.data is! Map ) return 0;
    return result.data['num'];
  }

  /// 4、最近学习
  ///
  static Future <List<StudyHistoryModel>> history({
    int page = 1,
    int limit = 10,
  }) async {
    final result = await HttpService.to.post(
      '/v1/members/Information/myReadRecord',
      params: {
        'currentPage': page,
        'pageSize': limit,
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return StudyHistoryModel.fromJson(result.data['list'][index]);
    });
  }

  /// 5、消息未读变已读
  ///
  static Future <bool> read({
    required String id
  }) async {
    final result = await HttpService.to.post(
      '/v1/message/Message/editOneStatus',
      params: {
        'id':id
      },
    );
    if (result.data is Map && result.data['is_success'] == 1){
      return true;
    }
    return false;
  }

  /// 6、清除搜索记录
  ///
  static Future <bool> clear() async {
    final result = await HttpService.to.post(
      '/v1/book/Information/serachDel',
      params: {},
    );
    if (result.data is Map && result.data['is_success'] == 1){
      return true;
    }
    return false;
  }

  /// 7、搜索历史记录
  ///
  static Future <List<String>> searchRecords() async {
    final result = await HttpService.to.post(
      '/v1/book/Information/serachRecord',
      params: {},
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return result.data['list'][index]['name'];
    });
  }

  /// 8、搜索书籍
  ///
  static Future <List<CourseModel>> searchBooks({
    int page = 1,
    int limit = 20,
    required String keyWord
  }) async {
    final result = await HttpService.to.post(
      '/v1/book/Information/searchBook',
      params: {
        'currentPage': page,
        'pageSize': limit,
        'keyword':keyWord
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return CourseModel.fromJson(result.data['list'][index]);
    });
  }


}