part of widgets;

class CustomCard extends StatelessWidget {
  final String url;
  final double height;
  final double width;
  final BorderRadiusGeometry? borderRadius;
  final List<BoxShadow>? boxShadow;

  const CustomCard({super.key,
    required this.url,
    this.height = 102,
    this.width = 85,
    this.borderRadius,
    this.boxShadow,
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: BoxDecoration(
        color: Colors.white,
        borderRadius: borderRadius ?? BorderRadius.circular(3),
        boxShadow: boxShadow ?? [
          BoxShadow(
            color: const Color(0xFF707070).withOpacity(0.5),
            spreadRadius: 0,
            blurRadius: 4.5,
            offset: const Offset(0, 0),
          ),
        ],
      ),
      height: height,
      width: width,
      child: Container(
        padding: const EdgeInsets.all(2),
        child: CustomImage.network(url: url,placeholder: Image.asset('assets/images/book_placeholder.png'),),
      ),
    );
  }
}
