part of user_msg;

class MsgPage extends StatelessWidget {
  const MsgPage({Key? key}) : super(key: key);



  @override
  Widget build(BuildContext context) {
    return GetBuilder<MsgController>(
      init: MsgController(),
      builder:(controller) => Scaffold(
        appBar: AppBar(
          title: const Text('消息中心'),
          centerTitle: true,
        ),
        body: Container(
          color: Colours.cF9,
          child: CustomPullScrollView(
            controller: controller.refreshController,
            onRefresh: controller.onRefresh,
            onLoading: controller.onLoading,
            child:controller.msgs.isEmpty?Container(
              padding: EdgeInsets.only(top: 110.w),
              alignment: Alignment.center,
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  SizedBox(height: 152.w, width: 195.w,
                    child: Image.asset( 'assets/images/none.png',),),
                  SizedBox(height: 13.w,),
                ],
              ),
            ): ListView.builder(
                itemBuilder: (BuildContext context, int index){
                  MsgModel model = controller.msgs[index];
                  return GestureDetector(
                    child: BuildItem(model:model,),
                    onTap: () async{
                        controller.read(model);

                        if(model.type == 1){
                          // final result = await context.pushNamed(Routes.order);
                          // if (result == true){
                          //   controller.onRefresh();
                          // }
                          final orderInfo = await controller.getOrderInfo(model.urlId?.orderNum??'');
                          // 待支付
                          if (orderInfo.status == 1){
                            // 书籍订单
                            if (orderInfo.types ==1){
                              context.pushNamed(Routes.orderAwaiting,
                                  queryParameters: {'orderNum': model.urlId?.orderNum.toString()});

                            }
                            // 充值订单
                            else {
                              context.pushNamed(Routes.orderCoinAwaiting,
                                  queryParameters: {'orderNum': model.urlId?.orderNum.toString()});

                            }

                          }
                          // 已取消
                          else if (orderInfo.status ==2){
                            if (orderInfo.types == 1){
                              context.pushNamed(Routes.orderCancel,
                                  queryParameters: {'orderNum': model.urlId?.orderNum.toString()});
                            }
                            else {
                              context.pushNamed(Routes.orderCoinCancel,
                                  queryParameters: {'orderNum': model.urlId?.orderNum.toString()});
                            }
                          }
                          // 已完成
                          else if (orderInfo.status ==3){
                            if (orderInfo.types == 1){
                              context.pushNamed(Routes.orderCompleted,
                                  queryParameters: {'orderNum': model.urlId?.orderNum.toString()});
                            }
                            else {
                              context.pushNamed(Routes.orderCoinCompleted,
                                  queryParameters: {'orderNum': model.urlId?.orderNum.toString()});
                            }
                          }
                          // 已退款
                          else if (orderInfo.status == 4){
                            if (orderInfo.types == 1){
                              context.pushNamed(Routes.orderRefunded,
                                  queryParameters: {'orderNum': model.urlId?.orderNum.toString()});
                            }
                          }

                          ///TODO:
                        }else if (model.type == 2){
                          // 2  购买完成三天未评价（跳转订单列表--已完成）
                          final orderInfo = await controller.getOrderInfo(model.urlId?.orderNum??'');

                          context.pushNamed(Routes.orderEvaluate,extra:orderInfo,
                              queryParameters: {'orderNum':orderInfo.ordersnum});

                          ///TODO:
                        }else if (model.type == 3){
                          // 3  讨论有人回复的时候 （跳转我的讨论详情也）

                          String bookId = model.urlId?.bookId.toString()??'';
                          BookDetailModel bookDetails = await LibraryAPI.details(bookId:bookId);
                          CourseModel courseModel = CourseModel(
                            img: bookDetails.img,
                            bookId: bookDetails.bookId,
                            bookName: bookDetails.bookName,
                            commentNum: bookDetails.commentNum

                          );
                          context.pushNamed(Routes.discussDes,extra: courseModel);

                        }
                        else if (model.type == 4){
                          // 4 订单完成后有新的积分增加（跳转用户积分记录页）
                          context.pushNamed(Routes.point);

                        }else if (model.type == 5){
                          // 5后台直接发放给指定用户优惠券（跳转到用户优惠券页）
                          context.pushNamed(Routes.coupon);
                        }

                    },
                  );
                },
                itemCount: controller.msgs.length,
            ),
          ),
        ),
      ),
    );
  }


}
