part of user_discuss_des;

class BuildDiscuss extends StatefulWidget {
  final DiscussModel model;
  final DiscussController? controller;
  final String bookId;
  const BuildDiscuss({
    Key? key,
    required this.model,
    this.controller,
    required this.bookId
  }) : super(key: key);

  @override
  State<BuildDiscuss> createState() => _BuildDiscussState();
}

class _BuildDiscussState extends State<BuildDiscuss> {
  final FocusNode _focusNode = FocusNode();

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.only(left: 10.w,right: 10.w),
      padding:  EdgeInsets.all(10.w),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(4.w),
        color: Colors.white,
        boxShadow: [
          BoxShadow(
            color: const Color(0xFFC7C7C7).withOpacity(0.5),
            offset: Offset(1.5.w, 0),
            blurRadius: 7.w,
            spreadRadius: 0.w,
          ),
        ],
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          RichText(text: TextSpan(
            children: [
              TextSpan(text: '话题：',style: TextStyle(
                  fontSize: 14.w,
                  height: 1.5.w,
                  color: Colours.c3,
              )),
              TextSpan(text: widget.model.title,style: TextStyle(
                  fontSize: 14.w,
                  height: 1.5.w,
                  color: Colours.c3,
                  fontWeight: Fonts.medium
              )),
            ]
          )),
          Gaps.vGaps10,
          Container(
            height: 0.5.w,
            color: Colours.cF2,
          ),
          _buildItem(widget.model),
          Container(
            margin:EdgeInsets.only(left: 15.w),
              child: _buildListView(widget.model.commentAll != null ? widget.model.commentAll!:[])
          ),
          Gaps.vGaps13,
          Container(
            width: double.infinity,
            padding: EdgeInsets.symmetric(vertical: 5.w,horizontal: 10.w),
            color: Colours.cF8,
            child:Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Text(widget.model.chapterName??'',style:  TextStyle(fontSize: 12.w,height: 1.5,color: Colours.c9),),
                Text('内容：${widget.model.quoteContent??''}',style: TextStyle(fontSize: 12.w,height: 1.5,color: Colours.c9),),
              ],
            )
          )
        ],
      ),
    );
  }

  Widget _buildItem(DiscussModel model,{int type =0}){
    return Row(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Container(
          margin: EdgeInsets.only(top: 10.w),
          child: ClipRRect(
            borderRadius: BorderRadius.circular(17.5.w),
            child: Container(
              width: 35.w,
              height: 35.w,
              color: Colors.red,
              child: CustomImage.network(url: model.personPic??''),
            ),
          ),
        ),
        Expanded(
          child: Container(
            margin: EdgeInsets.only(left: 10.w,top: 10.w),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    Row(
                      children: [
                        Text(model.personName??'',style: TextStyle(fontSize: 12.w,height: 1.5,color: Colours.c9),),
                        Gaps.hGaps10,
                        type ==1?const SizedBox(): Text('发起人',style: TextStyle(fontSize: 11.w,height: 1.5,color: AppTheme.primary),)
                      ],
                    ),
                    Text(model.createTime??'',style:  TextStyle(fontSize: 12.w,height: 1.5,color: Colours.c9),)
                  ],
                ),
                type ==0? Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Row(
                      children: [
                        Text(_showText(model),style: TextStyle(fontSize: 13.w,height: 1.5,color: Colours.c3),),
                        Text(_showStatus(model),style: TextStyle(fontSize: 13.w,height: 1.5,color: AppTheme.primary),),
                      ],
                    ),
                    Gaps.vGaps10,
                    _buildImageGridView()
                  ],
                )
                :RichText(text: TextSpan(
                  children: [
                    TextSpan(text: '回复 ',style: TextStyle(fontSize: 13.w,height: 1.5,color: Colours.c3)),
                    TextSpan(text: model.replacePersonName??'',style: TextStyle(fontSize: 13.w,height: 1.5,color: Colours.c9)),
                    TextSpan(text: '：${model.content?.text?.content??''}',style: TextStyle(fontSize: 13.w,height: 1.5,color: Colours.c3)),
                  ]
                )),
                SizedBox(height: 10.w,),
                Row(
                  children: [
                    Row(
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: [
                        GestureDetector(
                          onTap: () async{
                            widget.controller?.commentLove(discussModel: model);
                          },
                          child: SizedBox(
                            height: 20.w,
                            width: 20.w,
                            // color: Colors.green,
                            child: Image.asset(model.isPraise ==0?'assets/images/unlove.png': 'assets/images/love.png',fit: BoxFit.cover,),
                          ),
                        ),
                        Text(model.goodNum.toString(),style: TextStyle(fontSize:12.w,height: 1.5,color: Colours.c9))
                      ],
                    ),
                    Gaps.hGaps15,
                    Row(
                      children: [
                        GestureDetector(
                          onTap:(){
                            // _showKeyboard(context);
                            widget.controller?.setShow();
                            widget.controller?.setDiscussModel(model);
                          },
                          child: Container(
                            height: 25.w,
                            width: 15.w,
                            // color: Colors.yellow,
                            child: Image.asset('assets/images/reply.png',height: 15.w,width: 15.w,fit: BoxFit.fitWidth,),
                          ),
                        ),
                        SizedBox(width: 3.w,),
                        Text(model.replyNum.toString(),style: TextStyle(fontSize:12.w,height: 1.5,color: Colours.c9))
                      ],
                    )
                  ],
                )
              ],
            ),
          ),
        )
      ],
    );
  }

  String _showText(DiscussModel discussModel){
    String text = '';
    if (discussModel.commentsCheck==0 || discussModel.status == 1){
      // 是我的
      if(discussModel.isMy == 1){
        text = '${discussModel.content?.text?.content}';
      }
      else {
        if(discussModel.content?.text?.privacyStatus ==1){
          text = '${discussModel.content?.text?.content}';
        }
      }
    }
    return text;
  }
  String _showStatus(DiscussModel discussModel){
    String text = '';
    if ((discussModel.commentsCheck==0 && discussModel.status == 0) || discussModel.status == 1 ){
      // 是我的
      if(discussModel.isMy == 1){
        // 审核中
        if(discussModel.content?.text?.privacyStatus ==0 ||discussModel.content?.text?.privacyStatus ==2){
          text = '(审核中)';
        }
        // 审核未通过
        else if(discussModel.content?.text?.privacyStatus ==-1){
          text = '(审核未通过)';
        }
        // 审核通过
        else {
          text = '';
        }
      }
      else {
        // 审核中
        if(discussModel.content?.text?.privacyStatus ==0 ||discussModel.content?.text?.privacyStatus ==2){
          text = '(审核中)';
        }
        // 审核未通过
        else if(discussModel.content?.text?.privacyStatus ==-1){
          text = '(审核未通过)';
        }
        // 审核通过
        else {
          text = '';
        }
      }
    }else{
      if(discussModel.status == 0){
        text = '(审核中)';
      }
      else if(discussModel.status == 2){
        text = '(审核未通过)';
      }
    }

    return text;
  }
  Widget _buildListView(List<DiscussModel> data){
    return ListView.builder(
      physics: const NeverScrollableScrollPhysics(),
      shrinkWrap: true,
      itemBuilder: (BuildContext context,int index){
        return _buildItem(data[index],type: 1);
      },
      itemCount: data.length,
    );
  }

  // 图片
  Widget _buildImageGridView(){
    return GridView.builder(
      // padding: const EdgeInsets.only(left: 13,top: 10),
      physics: const NeverScrollableScrollPhysics(),
      shrinkWrap: true,
      gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
          crossAxisCount: 6,
          crossAxisSpacing: 2.w,
          mainAxisSpacing: 2.w,
          childAspectRatio: 1
      ),
      itemBuilder: (BuildContext context, int index) {
        MediaModel? mediaModel = widget.model.content?.image?[index];
        List<String>images = widget.model.content?.image?.map((MediaModel model) => model.content??'').toList()??[];
        return GestureDetector(
          onTap: (){
            context.pushNamed(Routes.imageView,extra:images);
          },
          child: Stack(
            children: [
              Positioned(
                  left: 0,
                  right:0,
                  top:0,
                  bottom: 0,
                  child: CustomImage.network(url: mediaModel?.content??'',fit: BoxFit.cover,)
              ),
              Visibility(
                visible: mediaModel?.privacyStatus == 0?true:false,
                child: Positioned(
                    left: 0,
                    right:0,
                    top:0,
                    bottom: 0,
                    child: Container(
                      alignment: Alignment.center,
                      color: widget.model.isMy==1?Colours.c9.withOpacity(0.5):Colours.c9.withOpacity(1),
                      child: Text('(审核中)',style: TextStyle(fontSize: 11.w,height: 1.5,color: AppTheme.primary),),
                    )
                ),
              ),
            ],
          ),
        );
        // return Container(
        //   color: Colors.red,
        // );
      },
      itemCount: widget.model.content?.image?.length,
      // itemCount: 2,
    );
  }

  void _showKeyboard(BuildContext context) {
    _focusNode.requestFocus();
    FocusScope.of(context).requestFocus(_focusNode);
    Overlay.of(context)?.insert(
      OverlayEntry(
        builder: (context) => Positioned(
          bottom: MediaQuery.of(context).viewInsets.bottom,
          left: 0,
          right: 0,
          child: Container(
            color: Colors.white,
            child: Padding(
              padding: const EdgeInsets.all(8.0),
              child: TextField(
                focusNode: _focusNode,
                decoration: InputDecoration(
                  hintText: '在这里回复',
                  filled: true,
                  fillColor: Colors.grey[200],
                  border: OutlineInputBorder(
                    borderRadius: BorderRadius.circular(10.0),
                  ),
                ),
              ),
            ),
          ),
        ),
      ),
    );
  }
}


