part of user_feedback;

class UserFeedbackPage extends StatefulWidget {
  const UserFeedbackPage({Key? key}) : super(key: key);

  @override
  State<UserFeedbackPage> createState() => _UserFeedbackPageState();
}

class _UserFeedbackPageState extends State<UserFeedbackPage> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
        appBar: AppBar(
          title: const Text('意见反馈'),
          centerTitle: true,
        ),
        body: Container(
          margin: const EdgeInsets.symmetric(horizontal: AppTheme.margin),
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(8),
            color: Colors.white,
          ),
          child: Column(
            mainAxisSize: MainAxisSize.min,
            children: [
              Container(
                alignment: Alignment.centerLeft,
                padding: const EdgeInsets.only(left: 10, top: 16.5),
                child: const Text.rich(TextSpan(children: [
                  TextSpan(
                      text: "*",
                      style: TextStyle(fontSize: 14, color: Colours.cAB1941)),
                  TextSpan(
                      text: "问题描述或建议",
                      style: TextStyle(
                          fontSize: 14,
                          color: Colours.c3,
                          fontWeight: FontWeight.bold)),
                ])),
              ),
              Container(
                padding: const EdgeInsets.only(left: 10, right:10,top: 6.5,bottom: 10),
                child:  const CustomInput(
                  maxLines: 5,
                  hintText: '请描述你的问题，我们会尽快处理并回复',
                ),
              ),

              // _buildTextField(context),
              Container(
                padding: const EdgeInsets.only(left: 10, right:10,top: 35,bottom: 20),
                width: double.infinity,
                child:  ElevatedButton(
                    onPressed: () {
                      print("提交反馈");
                    },
                    style: ButtonStyle(
                      backgroundColor: MaterialStateProperty.all(Colours.cAB1941),
                      shape: MaterialStateProperty.all(BeveledRectangleBorder(borderRadius: BorderRadius.circular(2))),//圆角弧度
                    ),
                    child: const Text(
                      "提交反馈",
                      style: TextStyle(fontSize: 14, color: Colours.cFF),
                    )),
              ),

            ],
          ),
        ));
  }

  Widget _buildTextField(BuildContext context) {
    return Container(
      padding: const EdgeInsets.only(left: 10, right:10,top:30),

      width: double.infinity,
      child: TextField(
        style: const TextStyle(color: Colors.blue,height: 3,),
        minLines: 5,
        maxLines: 5,
        cursorColor: Colours.c3,
        cursorRadius: const Radius.circular(3),
        cursorWidth: 1,
        showCursor: true,
        decoration: const InputDecoration(
          contentPadding: EdgeInsets.all(10),
          hintText: "请描述你的问题，我们会尽快处理并回复",
          border: OutlineInputBorder(),
        ),
        onChanged: (v) {},
      ),
    );
  }

}
