part of user_point;

class UserPointPage extends StatefulWidget {
  const UserPointPage({Key? key}) : super(key: key);

  @override
  State<UserPointPage> createState() => _UserPointPageState();
}

class _UserPointPageState extends State<UserPointPage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<UserPointController>(
      init: UserPointController(),
      builder: (controller) => Scaffold(
        appBar: AppBar(
          title: const Text('积分'),
        ),
        body: CustomPullScrollView(
          controller: controller.refreshController,
          onRefresh: controller.onRefresh,
          onLoading: controller.onLoading,
          child: Container(
            margin: const EdgeInsets.all(10),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(8),
              color: Colors.white,
              boxShadow: [
                BoxShadow(
                  color: const Color(0xFFC7C7C7).withOpacity(0.5),
                  offset: const Offset(3, 0),
                  blurRadius: 10.w,
                  spreadRadius: 0.w,
                ),
              ],
            ),
            child: ListView.builder(
              itemBuilder: (BuildContext context, int index){
                return BuildCell(model: controller.points[index],);
              },
              itemCount: controller.points.length,
            ),
          ),
        ),
      ),
    );
  }
}
