part of user_point;

class BuildCell extends StatelessWidget {
  final RecordModel model;
  const BuildCell({
    Key? key,
    required this.model
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Container(
          // color: Colors.green,
          padding: const EdgeInsets.symmetric(horizontal: 10),
          child: Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Container(
                child: Row(
                  children: [
                    Container(
                      width: 27,
                      height: 27,
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(13.5),
                        color: Colors.cyan,
                      ),
                    ),
                    Gaps.hGaps10,
                    Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Gaps.vGaps15,
                        Text(model.remarks??'',style: const TextStyle(color: Colours.c3,fontSize: 14,height: 1.6,fontWeight: Fonts.medium),),
                        Text(model.createTime??'',style:const TextStyle(color: Colours.c9,fontSize: 10,height: 1.6,)),
                        Gaps.vGaps15,
                      ],
                    )
                  ],
                ),
              ),
              Text(model.options == 1?'+${model.numbers}':'-${model.numbers}',style: const TextStyle(fontSize: 17,fontWeight: Fonts.medium,color: AppTheme.primary),)
            ],
          ),
        ),
        Container(color: Colours.cLine,margin: const EdgeInsets.symmetric(horizontal: 15),height: 1,),
      ],
    );
  }
}

