part of recharge;



class CoinRechargePage extends StatefulWidget {
  const CoinRechargePage({Key? key}) : super(key: key);

  @override
  State<CoinRechargePage> createState() => _CoinRechargePageState();
}

class _CoinRechargePageState extends State<CoinRechargePage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<CoinRechargeController>(
      init: CoinRechargeController(),
      builder:(controller) => Column(
        mainAxisSize: MainAxisSize.min,
        children: [
          Container(
            color: Colors.white,
            padding: EdgeInsets.symmetric(vertical: 17.w),
            width: double.infinity,
            margin: EdgeInsets.fromLTRB(10.w, 0.w, 10.w, 0.w),
            child: Container(
              // color: Colors.red,
              child:Stack(
                children: [
                  const Row(
                    mainAxisAlignment: MainAxisAlignment.center,
                    children: [
                      Text('紫荆币充值',textAlign:TextAlign.center),
                    ],
                  ),
                  Positioned(
                    right: 0.w,
                    top: 0.w,
                    child: GestureDetector(
                      onTap: (){
                        context.pop();
                      },
                      child: SizedBox(
                        width: 20.w,
                        height: 20.w,
                        child: Image.asset('assets/images/close.png'),
                      ),
                    ),
                  )
                ],
              )
            ),
          ),
          Container(
            margin: EdgeInsets.symmetric(horizontal: 20.w),
              child: _buildAudioGridView(controller)
          ),
          Gaps.vGaps15,
          _buildListView(controller),
          Gaps.vGaps15,
          Container(
            margin: EdgeInsets.symmetric(horizontal:15.w),
            child: CustomGradientButton(
              text: '立即充值${controller.rechargeModel.priceName??''}',
              isEnabled: true,
              onPressed: () {
                // context.goNamed(Routes.login);
              },
            ),
          ),
          Gaps.vGaps15,
          RichText(text: TextSpan(
            children: [
              TextSpan(text: '充值即代表同意',style: TextStyle(fontSize: 13.w,height: 1.5,color: Colours.c9)),
              TextSpan(text: '《用户充值协议》',style: TextStyle(fontSize: 13.w,height: 1.5,color: Color(0xFF2A82D9))),
            ]
          )),
          Gaps.vGaps15
        ],
      ),
    );
  }

  Widget _buildAudioGridView(CoinRechargeController controller){
    return GridView.builder(
      // padding: const EdgeInsets.only(left: 13,top: 10),
      physics: const NeverScrollableScrollPhysics(),
      shrinkWrap: true,
      gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
          crossAxisCount: 3,
          crossAxisSpacing: 10.w,
          mainAxisSpacing: 10.w,
          childAspectRatio: 2
      ),
      itemBuilder: (BuildContext context, int index) {
        CoinModel model = controller.data[index];
        return GestureDetector(
          onTap: (){
            controller.choose(model);
          },
          child: Container(
            decoration: BoxDecoration(
                color: model.selected?AppTheme.primary.withOpacity(0.1):Colors.white,
              borderRadius: BorderRadius.circular(8.w),
              border: Border.all(width: 0.5.w,color: model.selected?AppTheme.primary:const Color(0xFFDADADA))
            ),

            child: Column(
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                Text(model.beanName??'',style: TextStyle(color: model.selected?AppTheme.primary:Colours.c3,fontSize: 14.w,height: 1.5),),
                Text(model.priceName??'',style: TextStyle(color: model.selected?AppTheme.primary:Colours.c9,fontSize: 11.w,height: 1.5),),
              ],
            ),
          ),
        );
      },
      itemCount: controller.data.length,
    );
  }
  Widget _buildListView(CoinRechargeController controller){
    return ListView.builder(
      physics: const NeverScrollableScrollPhysics(),
      padding: EdgeInsets.symmetric(horizontal: 20.w),
      shrinkWrap:true,
      itemBuilder: (BuildContext context, int index){
        PayModel model = controller.pays[index];
        return GestureDetector(
            onTap: (){
              controller.setPayModel(model);
            },
            child: BuildPayWay(model:model,));
      },
      itemCount: controller.pays.length,
    );
  }
}
