part of models;

/// 已完成订单
class OrderCompletedModel {
  OrderCompletedModel(
      {required this.value, required this.name, this.link, this.other});

  String value;
  String name;
  String? link;
  String? other;
}

/// 已完成订单详细信息模型
class OrderCompletedInfoModel {
  OrderCompletedInfoModel({
    this.id,
    this.price,
    this.totalPay,
    this.favorable,
    this.orderId,
    this.payWay,
    this.payTime,
    this.orderTime,
  });

  OrderCompletedInfoModel.fromJson(dynamic json) {
    id = json['id'];
    price = json['price'];
    totalPay = json['totalPay'];
    favorable = json['favorable'];
    orderId = json['orderId'];
    payWay = json['payWay'];
    payTime = json['payTime'];
    orderTime = json['orderTime'];
  }

  num? id;
  String? price; // 价格
  String? totalPay;
  String? favorable; // 优惠
  String? orderId; // 订单编号
  String? payWay; // 支付方式
  String? payTime; // 支付时间
  String? orderTime; // 下单时间

  OrderCompletedInfoModel copyWith({
    num? id,
    String? price,
    String? totalPay,
    String? favorable,
    String? orderId,
    String? payWay,
    String? payTime,
    String? orderTime,
  }) =>
      OrderCompletedInfoModel(
        id: id ?? this.id,
        price: price ?? this.price,
        totalPay: totalPay ?? this.totalPay,
        favorable: favorable ?? this.favorable,
        orderId: orderId ?? this.orderId,
        payWay: payWay ?? this.payWay,
        payTime: payTime ?? this.payTime,
        orderTime: orderTime ?? this.orderTime,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['price'] = price;
    map['totalPay'] = totalPay;
    map['favorable'] = favorable;
    map['orderId'] = orderId;
    map['payWay'] = payWay;
    map['payTime'] = payTime;
    map['orderTime'] = orderTime;
    return map;
  }
}

/// 订单列表模型
class OrderListModel {
  OrderListModel({
    this.id,
    this.ordersnum,
    this.totalPrice,
    this.finalTotalPrice,
    this.num_,
    this.status,
    this.payType,
    this.types,
    this.createTime,
    this.cartList,
  });

  OrderListModel.fromJson(dynamic json) {
    id = json['id'];
    ordersnum = json['ordersnum'];
    totalPrice = json['total_price'];
    finalTotalPrice = json['final_total_price'];
    num_ = json['num'];
    status = json['status'];
    payType = json['pay_type'];
    types = json['types'];
    createTime = json['create_time'];
    if (json['cart_list'] != null) {
      cartList = [];
      json['cart_list'].forEach((v) {
        cartList?.add(CartListModel.fromJson(v));
      });
    }
  }

  num? id;  //订单id
  String? ordersnum; //订单编号
  String? totalPrice; // 原价总价
  String? finalTotalPrice; //最终总价
  num? num_; //商品数量
  num? status; //订单状态 1：待支付，2取消支付，3：已支付 4:已退款
  num? payType; //支付方式 1：微信 2：支付宝,3：紫荆币
  num? types; //1是书籍订单  2是充值订单
  String? createTime; //创建时间
  List<CartListModel>? cartList = [];

  OrderListModel copyWith({
    num? id,
    String? ordersnum,
    String? totalPrice,
    String? finalTotalPrice,
    num? num,
    num? status,
    num? payType,
    num? types,
    String? createTime,
    List<CartListModel>? cartList,
  }) =>
      OrderListModel(
        id: id ?? this.id,
        ordersnum: ordersnum ?? this.ordersnum,
        totalPrice: totalPrice ?? this.totalPrice,
        finalTotalPrice: finalTotalPrice ?? this.finalTotalPrice,
        status: status ?? this.status,
        num_: num_ ?? this.num_,
        payType: payType ?? this.payType,
        types: types ?? this.types,
        createTime: createTime ?? this.createTime,
        cartList: cartList ?? this.cartList,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['ordersnum'] = ordersnum;
    map['total_price'] = totalPrice;
    map['final_total_price'] = finalTotalPrice;
    map['num'] = num_;
    map['status'] = status;
    map['pay_type'] = payType;
    map['types'] = types;
    map['create_time'] = createTime;
    if (cartList != null) {
      map['cart_list'] = cartList?.map((v) => v.toJson()).toList();
    }
    return map;
  }
}

/// 书籍列表
class CartListModel {
  CartListModel({
    this.recordId,
    this.orderId,
    this.price,
    this.num_,
    this.bookId,
    this.name,
    this.img,
    this.introduction,
    this.rating,
    this.comments,
    this.commentId,
  });

  CartListModel.fromJson(dynamic json) {
    recordId = json['record_id'];
    orderId = json['order_id'];
    price = json['price'];
    num_ = json['num'];
    bookId = json['book_id'];
    name = json['name'];
    img = json['img'];
    introduction = json['introduction'];
    rating = json['rating'];
    comments = json['comments'];
    commentId = json['comment_id'];
  }

  num? recordId; //书籍记录id
  num? orderId; //对应订单id
  String? price; // 书籍价格
  num? num_; // 书籍价格
  num? bookId; //书籍id，为0则是充值的没有书籍
  String? name; // 书籍名
  String? img; // 图片
  String? introduction; // 简介
  num? rating; // 评价星级
  String? comments; // 评价内容
  String? commentId; // 评价id

  CartListModel copyWith({
    num? recordId, //书籍记录id
    num? orderId, //对应订单id
    String? price, // 书籍价格
    num? num_, // 书籍价格
    num? bookId, //书籍id，为0则是充值的没有书籍
    String? name, // 书籍名
    String? img, // 图片
    String? introduction, // 简介
    num? rating, // 评价星级
    String? comments, // 评价内容
    String? commentId, // 评价id
  }) =>
      CartListModel(
        recordId: recordId ?? this.recordId,
        orderId: orderId ?? this.orderId,
        price: price ?? this.price,
        num_: num_ ?? this.num_,
        bookId: bookId ?? this.bookId,
        name: name ?? this.name,
        img: img ?? this.img,
        introduction: introduction ?? this.introduction,
        rating: rating ?? this.rating,
        comments: comments ?? this.comments,
        commentId: commentId ?? this.commentId,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['record_id'] = recordId;
    map['order_id'] = orderId;
    map['num'] = num_;
    map['price'] = price;
    map['book_id'] = bookId;
    map['name'] = name;
    map['img'] = img;
    map['introduction'] = introduction;
    map['rating'] = rating;
    map['comments'] = comments;
    map['comment_id'] = commentId;
    return map;
  }
}
