part of order_evaluate;



class OrderEvaluatePage extends StatefulWidget {
  const OrderEvaluatePage({Key? key}) : super(key: key);

  @override
  State<OrderEvaluatePage> createState() => _OrderEvaluatePageState();
}

class _OrderEvaluatePageState extends State<OrderEvaluatePage> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        centerTitle: true,
        title: const Text('订单评价'),
      ),
      body: Column(
        children: [
          Container(
            margin: EdgeInsets.all(10.w),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(8.w),
              color: const Color(0xFFF9F9F9),
              boxShadow: [
                BoxShadow(
                  color: const Color(0xFFC7C7C7).withOpacity(0.5),
                  offset: Offset(3.w, 0),
                  blurRadius: 7.w,
                  spreadRadius: 0.w,
                ),
              ],
            ),
            child: ClipRRect(
              borderRadius: BorderRadius.circular(8.w),
              child: Column(
                mainAxisSize: MainAxisSize.min,
                children: [
                  // 图书容器
                  Container(
                    color: Colours.cF8,
                    padding: EdgeInsets.symmetric(horizontal: 11.w,vertical: 12.w),
                    child: Row(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Container(
                          width: 71.w,
                          height: 86.w,
                          color: Colors.cyan,
                        ),
                        Gaps.hGaps10,
                        Text('一想到还有95%的问题留给人类，我就放',style: TextStyle(fontSize: 13.w,height: 1.5,fontWeight: Fonts.medium,color: Colours.c3),maxLines: 2,overflow: TextOverflow.ellipsis,)

                      ],
                    ),
                  ),
                  // 评价容器
                  Container(
                    padding: EdgeInsets.symmetric(vertical: 15.w),
                    width: double.infinity,
                    height: 160.w,
                    color: Colors.white,
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Row(
                          crossAxisAlignment: CrossAxisAlignment.center,
                          children: [
                            Container(
                                padding: EdgeInsets.only(left: 10.w),
                                child: const Text('评分'),
                            ),
                            Gaps.hGaps20,
                            AbsorbPointer(
                              absorbing: false,
                              child: CustomRating(
                                max: 5,
                                score:0 ,
                                star: Star(
                                  fat: 0.5,
                                  progress: 7,
                                  fillColor: AppTheme.primary,
                                  size: 16.w,
                                  emptyColor: Colours.cE2,
                                ), onRating: (double ) {},
                              ),
                            ),
                          ],
                        ),
                        Container(
                          // color: Colors.red,
                          child:  CustomInput(
                            decoration:  InputDecoration(
                                focusedBorder: InputBorder.none,
                                border: InputBorder.none,
                                enabledBorder: InputBorder.none,
                                errorBorder: InputBorder.none,
                                fillColor:Colors.white,
                                hintStyle: TextStyle(fontSize: 14.w,height: 1.5,color: Colours.c6)
                            ),
                            maxLines: 5,
                            hintText: '请简要描述',
                          ),
                        ),

                      ],
                    ),
                  ),

                ],
              ),
            ),
          ),
          SizedBox(height: 50.w,),
          Container(
            margin: EdgeInsets.symmetric(horizontal: 10.w),
            child: CustomGradientButton(
              text: '提交评价',
              isEnabled: false,
              onPressed: () {
                print('11111111111111111');
              },
            ),
          )
        ],
      ),
    );
  }
}
