part of user_coupon;

class BuildItem extends StatelessWidget {
  final CouponModel model;
  const BuildItem({
    Key? key,
    required this.model
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return ColorFiltered(
      colorFilter: ColorFilter.mode(Colors.transparent, BlendMode.saturation),
      child: Container(
        margin: EdgeInsets.only(left: 10.w,top: 10.w,right: 5.w),
        child: Stack(
          children: [
            Container(
              child:Image.asset(
                  'assets/images/coupon_bg.png',
                fit: BoxFit.contain,
                width: double.infinity,
              ) ,
            ),
            Container(
            height: 105.w,
            child: Row(
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                Container(
                  width:120.w ,
                  height: 100.w,
                  child: Column(
                    children: [
                      RichText(
                        text: TextSpan(
                          children: <TextSpan>[
                            TextSpan(
                              text: '￥',
                              style: TextStyle(fontSize: 15.w,fontWeight: Fonts.boldSemi,height: 1.5,color: Colors.white)
                            ),
                            TextSpan(
                                text: '5',
                                style: TextStyle(fontSize: 40.w,fontWeight: Fonts.boldSemi,height: 1.5,color: Colors.white)
                            ),
                          ]
                        ),
                      ),
                      Text('满${model.normPrice}可用',style: TextStyle(fontSize: 11.w,height: 1.5,color: Colors.white),)
                    ],
                  ),
                  // color: Colors.cyan,
                ),
                Expanded(
                  child: Container(
                    margin: EdgeInsets.only(left:15.w,right: 15.w ),
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        SizedBox(
                          width: 139.w,
                          child:  Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            mainAxisAlignment: MainAxisAlignment.center,
                            children: [
                              Text(model.couponName??'',style: TextStyle(fontSize: 16.w,fontWeight: Fonts.medium,height: 1.5,color: Colours.c3),
                              maxLines: 1,overflow: TextOverflow.ellipsis,),
                              Gaps.vGaps5,
                              Text('满${model.normPrice}减${model.reducedPrice}元',style: TextStyle(fontSize: 12.w,height: 1.5,color: Colours.c9),
                                maxLines: 1,overflow: TextOverflow.ellipsis,),
                              Gaps.vGaps5,
                              Text('有效至：${model.endTime}',style: TextStyle(fontSize: 12.w,height: 1.5,color: Colours.c9),
                                maxLines: 1,overflow: TextOverflow.ellipsis,),
                            ],
                          ),
                        ),
                        Column(
                          crossAxisAlignment: CrossAxisAlignment.end,
                          mainAxisAlignment: MainAxisAlignment.center,
                          children: [
                            Align(
                              alignment: Alignment.bottomCenter,
                              child:  Container(
                                width: 65.w,
                                height: 24.w,
                                alignment: Alignment.center,
                                decoration: BoxDecoration(
                                    borderRadius: BorderRadius.circular(15.w),
                                    color: Colors.white,
                                    border: Border.all(width: 1.w,color: AppTheme.primary)
                                ),
                                child: Text('立即使用',style: TextStyle(fontSize: 12.w,fontWeight: Fonts.medium,color: AppTheme.primary),),
                              ),
                            ),

                            Gaps.vGaps10,
                            Text('优惠券使用规则',style: TextStyle(fontSize: 10.w,height: 1.5,color: Colours.cAB1941),
                              maxLines: 1,overflow: TextOverflow.ellipsis,),
                          ],
                        ),

                      ],
                    ),
                  ),
                )

              ],
            ),
          )
          ],
        ),
      ),
    );
  }
}
