part of recharge;

class CoinRechargeController extends GetxController {

  List<PayModel> pays =  Platform.isIOS ?[
  ]:[
    PayModel(type: 1, name: '微信', icon: 'assets/images/pay_wechat.png', selected: true),
    PayModel(type: 2, name: '支付宝', icon: 'assets/images/pay_ali.png', selected: false),
  ];
  List<CoinModel> data = [];

  late CoinModel rechargeModel = CoinModel();


  // 支付方式
  late PayModel _payModel = pays.first;
  PayModel get payModel => _payModel;


  @override
  void onReady() {
    _getlist();
    super.onReady();
  }

  void setPayModel(PayModel payModel){
    for (PayModel model in pays) {
      if (model.type == payModel.type){
        model.selected = true;
        _payModel = model;
      }
      else{
        model.selected = false;
      }
    }
    update();
  }

  void choose(CoinModel coinModel){
    for (CoinModel model in data) {
      model.selected = (model == coinModel);
    }
    rechargeModel = coinModel;
    update();
  }



  void _getlist()async{
    String type = '';
    if(Platform.isIOS){
      type = 'ios';
    }
    if(Platform.isAndroid){
      type = 'android';
    }
    final result = await MineAPI.coinsRechargeList(type: type);
    data = result;
    update();
  }


}